/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.util.HttpUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    private static final String PROJECT_ID = "pronounsadvanced";
    private final ProNouns plugin;
    private final Platform platform;
    private final URI uri;
    @Nullable
    private Version availableUpdate;

    public Optional<Version> availableUpdate() {
        return Optional.ofNullable(this.availableUpdate);
    }

    public UpdateChecker(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
        try {
            this.uri = new URI("https", "api.modrinth.com", "/v2/project/pronounsadvanced/version", "loaders=[\"" + platform.name().toLowerCase(Locale.ROOT) + "\"]", null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Version handle(JsonArray entries) {
        return entries.asList().stream().map(JsonElement::getAsJsonObject).map(v -> new Version(v.get("name").getAsString(), v.get("version_number").getAsString(), v.get("version_type").getAsString(), "https://modrinth.com/project/pronounsadvanced/version/" + v.get("id").getAsString())).filter(v -> this.plugin.platform().config().updateChannel().types().contains(v.channel)).findFirst().orElseThrow(() -> new UpdateCheckException(String.format("No versions are available for %s (%s)", this.platform.name(), this.plugin.platform().config().updateChannel().name().toLowerCase(Locale.ROOT))));
    }

    private void broadcast(Version version) {
        Formatter f = this.plugin.formatter();
        if (this.platform.currentVersion().equals(version.name)) {
            return;
        }
        this.availableUpdate = version;
        this.platform.broadcast((Component)Component.translatable((String)"pronouns.update").arguments(new ComponentLike[]{f.accent(version.displayName), f.accent("Modrinth").clickEvent(ClickEvent.openUrl((String)version.url)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)(version.url + "\nClick to open")))).decorate(TextDecoration.UNDERLINED)}), "pronouns.update");
    }

    public void checkForUpdates(boolean force) {
        if (this.availableUpdate != null && !force) {
            this.broadcast(this.availableUpdate);
            return;
        }
        HttpRequest req = HttpRequest.newBuilder().uri(this.uri).header("User-Agent", HttpUtil.userAgent(this.platform)).GET().build();
        try {
            HttpResponse<String> r = HttpUtil.client().send(req, HttpResponse.BodyHandlers.ofString());
            if (r.statusCode() / 100 != 2) {
                throw new UpdateCheckException("HTTP " + r.statusCode() + " " + String.valueOf(this.uri));
            }
            JsonArray body = JsonParser.parseString((String)r.body()).getAsJsonArray();
            this.broadcast(this.handle(body));
        }
        catch (Exception ex) {
            this.platform.logger().warn("Failed to check for updates: " + (ex.getCause() == null ? ex : ex.getCause()).toString());
        }
    }

    public record Version(String displayName, String name, String channel, String url) {
    }

    public static class UpdateCheckException
    extends RuntimeException {
        public UpdateCheckException(String s2) {
            super(s2);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static enum Channel {
        RELEASE("release"),
        BETA("release", "beta"),
        ALPHA("release", "beta", "alpha");

        private final List<String> types;

        private Channel(String ... types) {
            this.types = List.of(types);
        }

        public List<String> types() {
            return this.types;
        }
    }
}

