/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.arguments.flags.CommandFlag;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import net.cufufy.pronouns.shadow.cloud.permission.Permission;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClearCommand
implements ProNounsCommand {
    private final ProNouns plugin;
    private final Platform platform;

    public ClearCommand(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
    }

    public void execute(CommandSender commandSender, @Nullable String target) {
        CommandUtils.GetPlayerResult sender = CommandUtils.getPlayerOrSender(commandSender, target, this.platform);
        CommandSender player = sender.sender();
        if (player.uuid().isEmpty()) {
            player.sendMessage((Component)Component.translatable((String)"pronouns.command.noPlayer"));
            return;
        }
        this.plugin.store().set(player.uuid().get(), PronounStore.UNSET_LIST);
        commandSender.sendMessage(this.plugin.formatter().translated("pronouns.command.clear." + (sender.isNotSender() ? "other" : "self"), player.name()));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("clear", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("clear")).permission(ProNounsPermission.SET.key).flag(CommandFlag.builder("player").withPermission(Permission.of(ProNounsPermission.SET_OTHER.key)).withArgument(CommandUtils.optionalPlayer("player", this.platform))).handler(ctx -> this.execute((CommandSender)ctx.getSender(), ctx.getOrDefault("player", null)));
    }
}

