/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.util.Optional;
import net.cufufy.pronouns.common.message.ProNounsTranslations;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.standard.StringArgument;
import org.jetbrains.annotations.Nullable;

public class CommandUtils {
    public static GetPlayerResult getPlayerOrSender(CommandSender sender, @Nullable String playerName, Platform platform) {
        Optional<GetPlayerResult> targetSender = Optional.ofNullable(playerName).flatMap(platform::getPlayer);
        return targetSender.map(commandSender -> new GetPlayerResult((CommandSender)commandSender, true)).orElseGet(() -> new GetPlayerResult(sender, false));
    }

    public static CommandArgument<CommandSender, String> optionalPlayer(String name, Platform platform) {
        return StringArgument.builder(name).asOptional().withSuggestionsProvider((ctx, val) -> platform.listPlayers()).build();
    }

    public static String description(String name) {
        return ProNounsTranslations.translate("pronouns.command.desc." + name, new Object[0]);
    }

    public record GetPlayerResult(CommandSender sender, boolean isNotSender) {
    }
}

