/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.common.store.FilePronounStore;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;

public class DumpCommand
implements ProNounsCommand {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("d-MMM-yyyy-HH-mm");
    private final ProNouns plugin;
    private final Platform platform;

    public DumpCommand(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
    }

    private synchronized String dump() throws IOException {
        Map<UUID, List<PronounSet>> dump = this.plugin.store().dump();
        String date = DATE_FORMAT.format(new Date());
        String fileName = "pronouns-dump-" + date + ".properties";
        Path path = this.platform.dataDir().resolve(fileName);
        FilePronounStore.writeToFile(dump, path, new Date().toString());
        return fileName;
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("dump", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("dump")).permission(ProNounsPermission.DUMP.key).handler(ctx -> {
            String fileName;
            Formatter f = this.plugin.formatter();
            ((CommandSender)ctx.getSender()).sendMessage(f.translated("pronouns.command.dump.start", new String[0]));
            try {
                fileName = this.dump();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((CommandSender)ctx.getSender()).sendMessage(f.translated("pronouns.command.dump.finish", fileName));
        });
    }
}

