/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.util.List;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import org.jetbrains.annotations.Nullable;

public class GetCommand
implements ProNounsCommand {
    private final Platform platform;
    private final ProNouns plugin;

    public GetCommand(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
    }

    public void execute(CommandSender sender, @Nullable String target) {
        Formatter f = this.plugin.formatter();
        CommandUtils.GetPlayerResult targetCommandSender = CommandUtils.getPlayerOrSender(sender, target, this.platform);
        CommandSender targetPlayer = targetCommandSender.sender();
        if (targetPlayer.uuid().isEmpty()) {
            sender.sendMessage(f.translated("pronouns.command.noPlayer", new String[0]));
            return;
        }
        List<PronounSet> pronouns = this.plugin.store().sets(targetPlayer.uuid().get());
        if (pronouns.isEmpty() || pronouns.equals(PronounStore.UNSET_LIST)) {
            sender.sendMessage(f.translated("pronouns.command.get.unset." + (targetCommandSender.isNotSender() ? "other" : "self"), targetPlayer.name()));
            return;
        }
        sender.sendMessage(f.translated("pronouns.command.get." + (targetCommandSender.isNotSender() ? "other" : "self"), PronounSet.format(pronouns), targetPlayer.name()));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("get", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("get")).permission(ProNounsPermission.GET.key).argument(CommandUtils.optionalPlayer("player", this.platform)).handler(ctx -> this.execute((CommandSender)ctx.getSender(), ctx.getOrDefault("player", null)));
    }
}

