/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.CommandManager;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.StaticArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.standard.StringArgument;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public class HelpCommand
implements ProNounsCommand {
    private final CommandManager<CommandSender> manager;
    private final ProNouns plugin;
    private static final String NO_DESCRIPTION = "<italic>lucy is an idiot and forgot a description";

    private Component format(Command<?> command) {
        String name = command.getArguments().stream().filter(arg -> arg instanceof StaticArgument).skip(1L).findFirst().map(CommandArgument::getName).orElse("");
        String desc = command.getCommandMeta().get(CommandMeta.DESCRIPTION).orElse("");
        return this.plugin.formatter().translated("pronouns.command.help.entry", false, name, desc.equals("") ? NO_DESCRIPTION : desc);
    }

    public HelpCommand(ProNouns plugin, CommandManager<CommandSender> manager) {
        this.manager = manager;
        this.plugin = plugin;
    }

    public void execute(CommandSender sender, @Nullable String query) {
        TextComponent out = (TextComponent)((TextComponent)Component.empty().append(this.plugin.formatter().translated("pronouns.command.help.title", false, new String[0]))).append((Component)Component.newline());
        sender.sendMessage(out.append(this.manager.commands().stream().filter(cmd -> {
            if (cmd.isHidden() || cmd.getArguments().get(1).getName().equals("help")) {
                return false;
            }
            String perm = cmd.getCommandPermission().toString();
            return perm.equals("") || sender.hasPermission(perm);
        }).map(this::format).reduce((Component)Component.empty(), (last, cur) -> last.append((Component)Component.newline()).append(cur))));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("help", new String[0]).argument(StringArgument.optional("query")).handler(ctx -> this.execute((CommandSender)ctx.getSender(), ctx.getOrDefault("query", null)));
    }

    public Command.Builder<CommandSender> buildForRoot(Command.Builder<CommandSender> builder) {
        return builder.handler(ctx -> this.execute((CommandSender)ctx.getSender(), null));
    }
}

