/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.util.List;
import java.util.stream.Collectors;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import net.kyori.adventure.text.Component;

public class ListCommand
implements ProNounsCommand {
    private final ProNouns plugin;
    private final Platform platform;

    public ListCommand(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
    }

    public void execute(CommandSender sender) {
        Formatter formatter = this.plugin.formatter();
        List<String> availablePronouns = this.plugin.parser().getAvailablePronounNames();
        if (availablePronouns.isEmpty()) {
            sender.sendMessage(formatter.translated("pronouns.command.list.none", new String[0]));
            return;
        }
        String pronounListString = availablePronouns.stream().sorted().collect(Collectors.joining(", "));
        sender.sendMessage(formatter.translated("pronouns.command.list.header", new String[0]));
        sender.sendMessage((Component)Component.text((String)pronounListString));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("list", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("list")).permission(ProNounsPermission.LIST.key).handler(ctx -> this.execute((CommandSender)ctx.getSender()));
    }
}

