/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.common.LegacyMigrator;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.message.ProNounsTranslations;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.arguments.flags.CommandFlag;
import net.cufufy.pronouns.shadow.cloud.arguments.standard.EnumArgument;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import org.slf4j.Logger;

public class MigrateCommand
implements ProNounsCommand {
    private final ProNouns plugin;

    public MigrateCommand(ProNouns plugin) {
        this.plugin = plugin;
    }

    private void execute(CommandContext<CommandSender> context) {
        Path path;
        Logger logger = this.plugin.platform().logger();
        MigrationSource source = (MigrationSource)((Object)context.get("source"));
        logger.info(ProNounsTranslations.translate("pronouns.migrate.start", new Object[0]));
        if (source == MigrationSource.YML) {
            path = this.plugin.platform().dataDir().resolve("datastore.yml");
            if (!Files.exists(path, new LinkOption[0])) {
                logger.warn("No legacy datastore found to migrate.");
                return;
            }
        } else {
            throw new IllegalStateException("MySQL migration not yet supported");
        }
        Map<UUID, List<PronounSet>> sets = LegacyMigrator.fromYaml(path);
        this.plugin.store().setAll(sets);
        logger.info(ProNounsTranslations.translate("pronouns.migrate.finish", sets.size()));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("migrate", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("migrate")).permission(s2 -> s2.uuid().isEmpty()).argument(EnumArgument.builder(MigrationSource.class, "source")).flag(CommandFlag.builder("confirm")).handler(this::execute);
    }

    @Override
    public boolean shouldRegister() {
        return this.plugin.platform().migratable();
    }

    public static enum MigrationSource {
        YML,
        MYSQL;

    }
}

