/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.cmd;

import java.util.List;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.cmd.CommandUtils;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.shadow.cloud.ArgumentDescription;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.arguments.flags.CommandFlag;
import net.cufufy.pronouns.shadow.cloud.arguments.standard.StringArgument;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import net.cufufy.pronouns.shadow.cloud.permission.Permission;
import org.jetbrains.annotations.Nullable;

public class SetCommand
implements ProNounsCommand {
    private final ProNouns plugin;
    private final Platform platform;

    public SetCommand(ProNouns plugin, Platform platform) {
        this.plugin = plugin;
        this.platform = platform;
    }

    public void execute(CommandSender sender, String value, @Nullable String targetPlayer) {
        List<PronounSet> finalPronounsToSet;
        List<PronounSet> pronouns;
        Formatter f = this.plugin.formatter();
        CommandUtils.GetPlayerResult target = CommandUtils.getPlayerOrSender(sender, targetPlayer, this.platform);
        CommandSender player = target.sender();
        if (player.uuid().isEmpty()) {
            sender.sendMessage(f.translated("pronouns.command.noPlayer", new String[0]));
            return;
        }
        try {
            pronouns = this.plugin.parser().parse(value);
        }
        catch (Exception e) {
            this.plugin.platform().logger().warn("Pronoun parsing unexpectedly failed for input '" + value + "': " + e.getMessage());
            sender.sendMessage(f.translated("pronouns.command.set.parseError", value));
            return;
        }
        if (pronouns.isEmpty()) {
            sender.sendMessage(f.translated("pronouns.command.set.parseError", value));
            return;
        }
        boolean containsAsk = pronouns.stream().anyMatch(p -> p.equals(PronounSet.Builtins.ASK));
        if (containsAsk && pronouns.size() > 1) {
            finalPronounsToSet = List.of(PronounSet.Builtins.ASK);
            sender.sendMessage(f.translated("pronouns.command.set.askOverride", new String[0]));
        } else {
            finalPronounsToSet = pronouns;
        }
        this.plugin.store().set(player.uuid().get(), finalPronounsToSet);
        sender.sendMessage(f.translated("pronouns.command.set." + (target.isNotSender() ? "other" : "self"), PronounSet.format(finalPronounsToSet), player.name()));
    }

    @Override
    public Command.Builder<CommandSender> build(Command.Builder<CommandSender> builder) {
        return builder.literal("set", new String[0]).meta(CommandMeta.DESCRIPTION, CommandUtils.description("set")).permission(ProNounsPermission.SET.key).argument(StringArgument.greedyFlagYielding("pronouns")).flag(CommandFlag.builder("player").withPermission(Permission.of(ProNounsPermission.SET_OTHER.key)).withDescription(ArgumentDescription.of("A username of a player to set pronouns for.")).withArgument(CommandUtils.optionalPlayer("player", this.platform))).handler(ctx -> this.execute((CommandSender)ctx.getSender(), (String)ctx.get("pronouns"), ctx.getOrDefault("player", null)));
    }
}

