/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.placeholder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.cufufy.pronouns.api.Conjugator;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.placeholder.Placeholder;
import net.cufufy.pronouns.common.util.EnumUtil;

public class Placeholders {
    private final ProNouns plugin;
    public final Placeholder subjective = this.forPronoun("subjective", PronounSet::subjective);
    public final Placeholder objective = this.forPronoun("objective", PronounSet::objective);
    public final Placeholder possessiveAdj = this.forPronoun("possessiveadj", PronounSet::possessiveAdj);
    public final Placeholder possessive = this.forPronoun("possessive", PronounSet::possessive);
    public final Placeholder reflexive = this.forPronoun("reflexive", PronounSet::reflexive);
    public final Placeholder pronouns = this.forPronoun("pronouns", (List<PronounSet> userAllSets, ParsedArgs parsedArgs, PronounSet selectedSet) -> {
        if (userAllSets.isEmpty()) {
            return Placeholder.Result.of("");
        }
        return Placeholder.Result.of(PronounSet.format(userAllSets));
    });
    public final Placeholder all = this.forPronoun("all", (List<PronounSet> userAllSets, ParsedArgs parsedArgs, PronounSet selectedSet) -> {
        if (userAllSets.isEmpty()) {
            return Placeholder.Result.of("");
        }
        return Placeholder.Result.of(userAllSets.stream().map(PronounSet::toFullString).collect(Collectors.joining("; ")));
    });
    public final Placeholder verb = this.forPronoun("verb", (List<PronounSet> userAllSets, ParsedArgs parsedArgs, PronounSet selectedSet) -> {
        if (selectedSet == null) {
            return Placeholder.Result.of("");
        }
        if (parsedArgs.coreArgs.isEmpty()) {
            return Placeholder.Result.fail("Missing verb type for %pronouns_verb%");
        }
        String verbName = parsedArgs.coreArgs.get(0);
        Optional<Conjugator> verbEnum = EnumUtil.getByName(Conjugator.class, verbName);
        return verbEnum.map(conjugator -> Placeholder.Result.of(conjugator.conjugate(selectedSet.plural()))).orElseGet(() -> Placeholder.Result.fail("Unknown verb " + verbName + " for %pronouns_verb%"));
    });
    public final Placeholder conjugate = this.forPronoun("conj", (List<PronounSet> userAllSets, ParsedArgs parsedArgs, PronounSet selectedSet) -> {
        if (selectedSet == null) {
            return Placeholder.Result.of("");
        }
        if (parsedArgs.coreArgs.size() < 2) {
            return Placeholder.Result.fail("Missing options for %pronouns_conj%");
        }
        return Placeholder.Result.of(parsedArgs.coreArgs.get(selectedSet.plural() ? 1 : 0));
    });

    private static String applyModifiers(PronounSet selectedSet, String value, List<String> modifierStrings) {
        String out = value;
        if (modifierStrings.contains("nounset") && (selectedSet == null || selectedSet.equals(PronounSet.Builtins.UNSET))) {
            return "";
        }
        if (selectedSet == null && value.isEmpty()) {
            return "";
        }
        Iterator<String> iterator = modifierStrings.iterator();
        while (iterator.hasNext()) {
            String mod;
            out = switch (mod = iterator.next()) {
                case "uppercase" -> out.toUpperCase(Locale.ROOT);
                case "lowercase" -> out.toLowerCase(Locale.ROOT);
                case "capital" -> {
                    if (out.isEmpty()) {
                        yield "";
                    }
                    if (out.length() == 1) {
                        yield out.toUpperCase(Locale.ROOT);
                    }
                    yield out.substring(0, 1).toUpperCase(Locale.ROOT) + out.substring(1).toLowerCase(Locale.ROOT);
                }
                case "nounset" -> out;
                default -> out;
            };
        }
        return out;
    }

    private Placeholder forPronoun(String name, TriFunction<List<PronounSet>, ParsedArgs, PronounSet, Placeholder.Result> valueProducer) {
        return new Placeholder(name, (sender, s_args) -> {
            if (sender.uuid().isEmpty()) {
                return Placeholder.Result.fail("No player");
            }
            List<PronounSet> userAllSets = this.plugin.store().sets(sender.uuid().get());
            ParsedArgs parsedArgs = new ParsedArgs((String)s_args);
            PronounSet selectedSet = null;
            boolean selectionFailedDueToInvalidIndex = false;
            if (userAllSets.isEmpty()) {
                if (parsedArgs.indexExplicitlyPresent) {
                    selectionFailedDueToInvalidIndex = true;
                }
            } else if (parsedArgs.index.isPresent()) {
                int idx = parsedArgs.index.get();
                if (idx > 0 && idx <= userAllSets.size()) {
                    selectedSet = userAllSets.get(idx - 1);
                } else {
                    selectionFailedDueToInvalidIndex = true;
                }
            } else {
                selectedSet = userAllSets.get(0);
            }
            if (selectionFailedDueToInvalidIndex) {
                return Placeholder.Result.of(Placeholders.applyModifiers(null, "", parsedArgs.modifierStrings));
            }
            Placeholder.Result producedResult = (Placeholder.Result)valueProducer.apply(userAllSets, parsedArgs, selectedSet);
            if (producedResult.success()) {
                return Placeholder.Result.of(Placeholders.applyModifiers(selectedSet, producedResult.message(), parsedArgs.modifierStrings));
            }
            return producedResult;
        });
    }

    private Placeholder forPronoun(String name, Function<PronounSet, String> singleSetToString) {
        return this.forPronoun(name, (List<PronounSet> userAllSets, ParsedArgs parsedArgs, PronounSet selectedSet) -> {
            if (selectedSet == null) {
                return Placeholder.Result.of("");
            }
            return Placeholder.Result.of((String)singleSetToString.apply((PronounSet)selectedSet));
        });
    }

    public Placeholders(ProNouns plugin) {
        this.plugin = plugin;
    }

    public Set<Placeholder> placeholders() {
        return Set.of(this.subjective, this.objective, this.possessiveAdj, this.possessive, this.reflexive, this.pronouns, this.all, this.verb, this.conjugate);
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }

    private static class ParsedArgs {
        final List<String> coreArgs = new ArrayList<String>();
        Optional<Integer> index = Optional.empty();
        final List<String> modifierStrings = new ArrayList<String>();
        boolean indexExplicitlyPresent = false;

        ParsedArgs(String fullArgString) {
            String[] parts = fullArgString.split("[_ ]");
            Set<String> knownModifiers = Set.of("uppercase", "lowercase", "capital", "nounset");
            boolean foundIndexInThisPass = false;
            for (String part : parts) {
                if (part.isEmpty()) continue;
                if (!foundIndexInThisPass) {
                    try {
                        this.index = Optional.of(Integer.parseInt(part));
                        this.indexExplicitlyPresent = true;
                        foundIndexInThisPass = true;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (knownModifiers.contains(part.toLowerCase(Locale.ROOT))) {
                    this.modifierStrings.add(part.toLowerCase(Locale.ROOT));
                    continue;
                }
                this.coreArgs.add(part);
            }
        }
    }
}

