/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.platform.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import net.cufufy.pronouns.common.UpdateChecker;
import net.cufufy.pronouns.common.platform.config.Config;
import net.cufufy.pronouns.common.platform.config.InvalidConfigurationException;
import net.cufufy.pronouns.common.util.PropertiesUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PropertiesConfig
implements Config {
    private final Path path;
    private final Logger logger;
    private boolean checkForUpdates;
    private UpdateChecker.Channel updateChannel;
    private String main;
    private String accent;
    private boolean stats;
    private String store;
    @Nullable
    private String mysqlUrl;
    @Nullable
    private String mysqlUsername;
    @Nullable
    private String mysqlPassword;

    private String getValue(Properties properties, String key, String defaultValue) {
        Object out = properties.getOrDefault((Object)key, defaultValue);
        if (out == null) {
            throw new InvalidConfigurationException("Missing required value " + key);
        }
        return (String)out;
    }

    public PropertiesConfig(Path path, Logger logger) {
        this.path = path;
        this.logger = logger;
    }

    public Config reloadConfig() throws IOException {
        Properties props;
        if (!Files.exists(this.path, new LinkOption[0])) {
            try (InputStream config = PropertiesConfig.class.getResourceAsStream("/pronouns-default.cfg");){
                assert (config != null);
                Files.copy(config, this.path, new CopyOption[0]);
            }
        }
        this.checkForUpdates = !this.getValue(props = PropertiesUtil.fromFile(this.path), "checkForUpdates", "true").equals("false");
        this.stats = !this.getValue(props, "stats", "true").equals("false");
        String channelString = this.getValue(props, "updateChannel", "release");
        this.updateChannel = switch (channelString.trim().toLowerCase(Locale.ROOT)) {
            case "alpha" -> UpdateChecker.Channel.ALPHA;
            case "beta" -> UpdateChecker.Channel.BETA;
            case "release" -> UpdateChecker.Channel.RELEASE;
            default -> {
                this.logger.warn("Unknown update channel " + channelString + ", falling back to release.");
                yield UpdateChecker.Channel.RELEASE;
            }
        };
        this.main = this.getValue(props, "main", "<reset>");
        this.accent = this.getValue(props, "accent", "<gradient:#fa9efa:#9dacfa>");
        this.store = this.getValue(props, "store", null);
        this.mysqlUrl = props.getProperty("mysql.url");
        this.mysqlUsername = props.getProperty("mysql.username");
        this.mysqlPassword = props.getProperty("mysql.password");
        return this;
    }

    @Override
    public void reload() {
        try {
            this.reloadConfig();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public String store() {
        return this.store;
    }

    @Override
    public boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    @Override
    public UpdateChecker.Channel updateChannel() {
        return this.updateChannel;
    }

    @Override
    public String main() {
        return this.main;
    }

    @Override
    public String accent() {
        return this.accent;
    }

    @Override
    public boolean stats() {
        return this.stats;
    }

    @Override
    public Config.MySqlConnectionInfo mysql() {
        if (this.mysqlUrl == null) {
            throw new InvalidConfigurationException("Missing MySQL URL");
        }
        if (this.mysqlUsername == null) {
            throw new InvalidConfigurationException("Missing MySQL username");
        }
        if (this.mysqlPassword == null) {
            throw new InvalidConfigurationException("Missing MySQL password");
        }
        return new Config.MySqlConnectionInfo(this.mysqlUrl, this.mysqlUsername, this.mysqlPassword);
    }
}

