/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.store;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.cufufy.pronouns.api.ProNounsPlugin;
import net.cufufy.pronouns.api.PronounParser;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.api.supplier.PronounSupplier;
import net.cufufy.pronouns.common.util.PropertiesUtil;
import org.jetbrains.annotations.NotNull;

public class FilePronounStore
implements PronounStore {
    private final ProNounsPlugin plugin;
    private final Path filePath;
    private final Map<UUID, List<PronounSet>> sets = new HashMap<UUID, List<PronounSet>>();
    private static final PronounParser parser = new PronounParser(PronounSet.builtins);

    public FilePronounStore(Path actualFilePath, ProNounsPlugin plugin) {
        Properties properties;
        this.plugin = plugin;
        this.filePath = actualFilePath;
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            properties = PropertiesUtil.fromFile(this.filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.sets.put(UUID.fromString((String)key), parser.parse((String)value))));
    }

    public static void writeToFile(Map<UUID, List<PronounSet>> sets, Path path, String header) throws IOException {
        Properties props = new Properties();
        sets.forEach((uuid, pronounSets) -> props.put(uuid.toString(), pronounSets.stream().map(PronounSet::toFullString).collect(Collectors.joining(";"))));
        try (OutputStream outStream = Files.newOutputStream(path, new OpenOption[0]);){
            props.store(outStream, header);
        }
    }

    private void save() {
        try {
            FilePronounStore.writeToFile(this.sets, this.filePath, "ProNouns storage file. This file should not be edited while the server is running");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PronounSupplier predefined() {
        return PronounSet.builtins;
    }

    @Override
    public List<PronounSet> sets(UUID player) {
        return this.sets.getOrDefault(player, UNSET_LIST);
    }

    @Override
    public void set(UUID player, @NotNull List<PronounSet> sets) {
        if (sets.size() == 0) {
            this.sets.remove(player);
        } else {
            this.sets.put(player, sets);
        }
        this.plugin.executorService().execute(this::save);
    }

    @Override
    public void setAll(Map<UUID, List<PronounSet>> sets) {
        sets.forEach(this.sets::putIfAbsent);
        this.plugin.executorService().execute(this::save);
    }

    @Override
    public Map<UUID, List<PronounSet>> dump() {
        return Collections.unmodifiableMap(this.sets);
    }

    @Override
    public void addPronouns(UUID player, @NotNull List<PronounSet> pronounsToAdd) {
        if (pronounsToAdd.isEmpty()) {
            return;
        }
        ArrayList<PronounSet> currentSets = new ArrayList<PronounSet>(this.sets(player));
        if (currentSets.size() == 1 && ((PronounSet)currentSets.get(0)).equals(PronounSet.Builtins.UNSET)) {
            if (pronounsToAdd.size() == 1 && pronounsToAdd.get(0).equals(PronounSet.Builtins.UNSET)) {
                return;
            }
            currentSets.clear();
        }
        for (PronounSet toAdd : pronounsToAdd) {
            if (currentSets.contains(toAdd)) continue;
            currentSets.add(toAdd);
        }
        this.set(player, currentSets);
    }

    @Override
    public void removePronouns(UUID player, @NotNull List<PronounSet> pronounsToRemove) {
        if (pronounsToRemove.isEmpty()) {
            return;
        }
        ArrayList<PronounSet> currentSets = new ArrayList<PronounSet>(this.sets(player));
        if (currentSets.size() == 1 && ((PronounSet)currentSets.get(0)).equals(PronounSet.Builtins.UNSET)) {
            if (pronounsToRemove.contains(PronounSet.Builtins.UNSET)) {
                this.set(player, Collections.emptyList());
            }
            return;
        }
        currentSets.removeAll(pronounsToRemove);
        this.set(player, currentSets);
    }
}

