/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.api.supplier.PronounSupplier;
import org.jetbrains.annotations.NotNull;

public class InMemoryPronounStore
implements PronounStore {
    private final Map<UUID, List<PronounSet>> storage = new HashMap<UUID, List<PronounSet>>();

    @Override
    public PronounSupplier predefined() {
        return PronounSet.builtins;
    }

    @Override
    public List<PronounSet> sets(UUID player) {
        return this.storage.getOrDefault(player, UNSET_LIST);
    }

    @Override
    public void set(UUID player, @NotNull List<PronounSet> sets) {
        if (sets.size() == 0) {
            this.storage.remove(player);
        } else {
            this.storage.put(player, sets);
        }
    }

    @Override
    public void setAll(Map<UUID, List<PronounSet>> sets) {
        sets.forEach(this.storage::putIfAbsent);
    }

    @Override
    public void addPronouns(UUID player, @NotNull List<PronounSet> pronounsToAdd) {
        if (pronounsToAdd.isEmpty()) {
            return;
        }
        ArrayList<PronounSet> currentSets = new ArrayList<PronounSet>(this.sets(player));
        if (currentSets.size() == 1 && ((PronounSet)currentSets.get(0)).equals(PronounSet.Builtins.UNSET)) {
            if (pronounsToAdd.size() == 1 && pronounsToAdd.get(0).equals(PronounSet.Builtins.UNSET)) {
                return;
            }
            currentSets.clear();
        }
        for (PronounSet toAdd : pronounsToAdd) {
            if (currentSets.contains(toAdd)) continue;
            currentSets.add(toAdd);
        }
        this.set(player, currentSets);
    }

    @Override
    public void removePronouns(UUID player, @NotNull List<PronounSet> pronounsToRemove) {
        if (pronounsToRemove.isEmpty()) {
            return;
        }
        ArrayList<PronounSet> currentSets = new ArrayList<PronounSet>(this.sets(player));
        if (currentSets.size() == 1 && ((PronounSet)currentSets.get(0)).equals(PronounSet.Builtins.UNSET)) {
            if (pronounsToRemove.contains(PronounSet.Builtins.UNSET)) {
                this.set(player, Collections.emptyList());
            }
            return;
        }
        currentSets.removeAll(pronounsToRemove);
        this.set(player, currentSets);
    }

    @Override
    public Map<UUID, List<PronounSet>> dump() {
        return Collections.unmodifiableMap(this.storage);
    }
}

