/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common.store;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.store.FilePronounStore;
import net.cufufy.pronouns.common.store.InMemoryPronounStore;
import net.cufufy.pronouns.common.store.MySqlPronounStore;

public class StoreFactory {
    private final Map<String, Supplier<PronounStore>> suppliers = new HashMap<String, Supplier<PronounStore>>();

    public void register(String key, Supplier<PronounStore> supplier) {
        if (this.suppliers.putIfAbsent(key, supplier) != null) {
            throw new IllegalStateException("Store supplier with key " + key + " already registered");
        }
    }

    public PronounStore create(String key, ProNouns plugin) {
        return switch (key) {
            case "in_memory" -> new InMemoryPronounStore();
            case "file" -> new FilePronounStore(plugin.platform().dataDir().resolve("pronouns-store.properties"), plugin);
            case "mysql" -> new MySqlPronounStore(plugin, plugin.platform().config().mysql());
            default -> {
                Supplier<PronounStore> supplier = this.suppliers.get(key);
                if (supplier == null) {
                    throw new IllegalStateException("Unknown pronoun store type " + key);
                }
                yield supplier.get();
            }
        };
    }
}

