/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.paper;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.platform.config.Config;
import net.cufufy.pronouns.common.platform.config.PropertiesConfig;
import net.cufufy.pronouns.paper.BukkitCommandSenderWrapper;
import net.cufufy.pronouns.paper.ProNounsPaper;
import net.cufufy.pronouns.shadow.cloud.CommandManager;
import net.cufufy.pronouns.shadow.cloud.execution.CommandExecutionCoordinator;
import net.cufufy.pronouns.shadow.cloud.paper.PaperCommandManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public class PaperPlatform
implements Platform {
    private final ProNounsPaper plugin;
    private final CommandManager<CommandSender> manager;
    private final Config config;

    public PaperPlatform(ProNounsPaper plugin) {
        this.plugin = plugin;
        try {
            this.manager = new PaperCommandManager<CommandSender>((Plugin)plugin, CommandExecutionCoordinator.simpleCoordinator(), BukkitCommandSenderWrapper::new, sender -> ((BukkitCommandSenderWrapper)sender).bukkitSender());
            this.config = new PropertiesConfig(plugin.getDataFolder().toPath().resolve("pronouns.cfg"), this.logger()).reloadConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String name() {
        return "Paper";
    }

    @Override
    public String currentVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    @Override
    public String minecraftVersion() {
        return Bukkit.getMinecraftVersion();
    }

    @Override
    public Path dataDir() {
        return this.plugin.getDataFolder().toPath();
    }

    @Override
    public Logger logger() {
        return this.plugin.getSLF4JLogger();
    }

    @Override
    public void broadcast(Component component, String permission) {
        Bukkit.broadcast((Component)component, (String)permission);
    }

    @Override
    public CommandManager<CommandSender> commandManager() {
        return this.manager;
    }

    @Override
    public Optional<CommandSender> getPlayer(String name) {
        return Optional.ofNullable(Bukkit.getPlayer((String)name)).map(BukkitCommandSenderWrapper::new);
    }

    @Override
    public Optional<CommandSender> getPlayer(UUID uuid) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(BukkitCommandSenderWrapper::new);
    }

    @Override
    public List<String> listPlayers() {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public boolean migratable() {
        return true;
    }

    @Override
    public String[] commandAliases() {
        return new String[]{"pronounspaper", "pnpaper", "pnp"};
    }
}

