/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.paper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.cufufy.pronouns.api.PronounParser;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.api.supplier.PronounSupplier;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class PersistentDataContainerStore
implements PronounStore {
    private static final NamespacedKey KEY = new NamespacedKey("pronouns", "pronouns");
    private static final PronounParser parser = new PronounParser(PronounSet.builtins);

    @Override
    public PronounSupplier predefined() {
        return PronounSet.builtins;
    }

    private Player getPlayer(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            throw new IllegalArgumentException("Unknown player " + String.valueOf(uuid));
        }
        return player;
    }

    @Override
    public List<PronounSet> sets(UUID player) {
        String key = (String)this.getPlayer(player).getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (key == null) {
            return UNSET_LIST;
        }
        return parser.parse(key);
    }

    @Override
    public void set(UUID player, @NotNull List<PronounSet> sets) {
        PersistentDataContainer pdc = this.getPlayer(player).getPersistentDataContainer();
        if (sets.size() == 0) {
            pdc.remove(KEY);
        } else {
            pdc.set(KEY, PersistentDataType.STRING, (Object)sets.stream().map(PronounSet::toFullString).collect(Collectors.joining(";")));
        }
    }

    @Override
    public void addPronouns(UUID player, @NotNull List<PronounSet> setsToAdd) {
        if (setsToAdd.isEmpty()) {
            return;
        }
        ArrayList<PronounSet> currentSets = new ArrayList<PronounSet>(this.sets(player));
        if (currentSets == UNSET_LIST) {
            currentSets = new ArrayList();
        }
        currentSets.addAll(setsToAdd);
        this.set(player, currentSets);
    }

    @Override
    public void removePronouns(UUID player, @NotNull List<PronounSet> setsToRemove) {
        if (setsToRemove.isEmpty()) {
            return;
        }
        List<PronounSet> currentSets = this.sets(player);
        if (currentSets.isEmpty() || currentSets == UNSET_LIST) {
            return;
        }
        ArrayList<PronounSet> mutableCurrentSets = new ArrayList<PronounSet>(currentSets);
        mutableCurrentSets.removeAll(setsToRemove);
        this.set(player, mutableCurrentSets);
    }

    @Override
    public void setAll(Map<UUID, List<PronounSet>> sets) {
        throw new UnsupportedOperationException("PDC (paper NBT) store does not support setting all");
    }

    @Override
    public Map<UUID, List<PronounSet>> dump() {
        throw new UnsupportedOperationException("PDC (paper NBT) store does not support dumping");
    }
}

