/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.paper;

import net.cufufy.pronouns.common.ProNouns;
import net.cufufy.pronouns.common.analytics.Metrics;
import net.cufufy.pronouns.common.platform.ProNounsPermission;
import net.cufufy.pronouns.common.store.StoreFactory;
import net.cufufy.pronouns.paper.PaperDetector;
import net.cufufy.pronouns.paper.PaperPlatform;
import net.cufufy.pronouns.paper.PersistentDataContainerStore;
import net.cufufy.pronouns.paper.PlaceholderAPIHook;
import net.cufufy.pronouns.paper.PlayerEventHandler;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ProNounsPaper
extends JavaPlugin {
    private static final StoreFactory factory = new StoreFactory();
    private ProNouns plugin;

    public void onEnable() {
        if (!PaperDetector.IS_PAPER) {
            throw new RuntimeException("ProNouns requires Paper to run. Get it at https://papermc.io. The plugin will now disable itself.");
        }
        this.getDataFolder().mkdir();
        for (ProNounsPermission perm : ProNounsPermission.values()) {
            this.getServer().getPluginManager().addPermission(new Permission(perm.key, perm.description, perm.defaultLevel > 0 ? PermissionDefault.OP : PermissionDefault.TRUE));
        }
        PaperPlatform platform = new PaperPlatform(this);
        this.plugin = new ProNouns(platform);
        this.plugin.createStore(factory);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventHandler(this), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("Registering PlaceholderAPI hook.");
            new PlaceholderAPIHook(this.plugin, platform).register();
        }
        if (platform.config().stats()) {
            int pluginId = 26256;
            Metrics metrics = new Metrics(this, pluginId);
            this.getLogger().info("bStats metrics enabled.");
        } else {
            this.getLogger().info("bStats metrics disabled by config.");
        }
    }

    public ProNouns getPlugin() {
        return this.plugin;
    }

    static {
        factory.register("nbt", PersistentDataContainerStore::new);
    }
}

