/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.cufufy.pronouns.shadow.cloud.ArgumentDescription;
import net.cufufy.pronouns.shadow.cloud.CloudCapability;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.CommandHelpHandler;
import net.cufufy.pronouns.shadow.cloud.CommandTree;
import net.cufufy.pronouns.shadow.cloud.Description;
import net.cufufy.pronouns.shadow.cloud.annotations.injection.ParameterInjectorRegistry;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandSuggestionEngine;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandSyntaxFormatter;
import net.cufufy.pronouns.shadow.cloud.arguments.DelegatingCommandSuggestionEngineFactory;
import net.cufufy.pronouns.shadow.cloud.arguments.StandardCommandSyntaxFormatter;
import net.cufufy.pronouns.shadow.cloud.arguments.StaticArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.flags.CommandFlag;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ParserRegistry;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.StandardParserRegistry;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionRegistry;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionVariableReplacementHandler;
import net.cufufy.pronouns.shadow.cloud.captions.SimpleCaptionRegistryFactory;
import net.cufufy.pronouns.shadow.cloud.captions.SimpleCaptionVariableReplacementHandler;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.context.CommandContextFactory;
import net.cufufy.pronouns.shadow.cloud.context.StandardCommandContextFactory;
import net.cufufy.pronouns.shadow.cloud.execution.CommandExecutionCoordinator;
import net.cufufy.pronouns.shadow.cloud.execution.CommandResult;
import net.cufufy.pronouns.shadow.cloud.execution.CommandSuggestionProcessor;
import net.cufufy.pronouns.shadow.cloud.execution.FilteringCommandSuggestionProcessor;
import net.cufufy.pronouns.shadow.cloud.execution.postprocessor.AcceptingCommandPostprocessor;
import net.cufufy.pronouns.shadow.cloud.execution.postprocessor.CommandPostprocessingContext;
import net.cufufy.pronouns.shadow.cloud.execution.postprocessor.CommandPostprocessor;
import net.cufufy.pronouns.shadow.cloud.execution.preprocessor.AcceptingCommandPreprocessor;
import net.cufufy.pronouns.shadow.cloud.execution.preprocessor.CommandPreprocessingContext;
import net.cufufy.pronouns.shadow.cloud.execution.preprocessor.CommandPreprocessor;
import net.cufufy.pronouns.shadow.cloud.internal.CommandInputTokenizer;
import net.cufufy.pronouns.shadow.cloud.internal.CommandRegistrationHandler;
import net.cufufy.pronouns.shadow.cloud.meta.CommandMeta;
import net.cufufy.pronouns.shadow.cloud.permission.AndPermission;
import net.cufufy.pronouns.shadow.cloud.permission.CommandPermission;
import net.cufufy.pronouns.shadow.cloud.permission.OrPermission;
import net.cufufy.pronouns.shadow.cloud.permission.Permission;
import net.cufufy.pronouns.shadow.cloud.permission.PredicatePermission;
import net.cufufy.pronouns.shadow.cloud.services.ServicePipeline;
import net.cufufy.pronouns.shadow.cloud.services.State;
import net.cufufy.pronouns.shadow.geantyref.TypeToken;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public abstract class CommandManager<C> {
    private final Map<Class<? extends Exception>, BiConsumer<C, ? extends Exception>> exceptionHandlers = new HashMap<Class<? extends Exception>, BiConsumer<C, ? extends Exception>>();
    private final EnumSet<ManagerSettings> managerSettings = EnumSet.of(ManagerSettings.ENFORCE_INTERMEDIARY_PERMISSIONS);
    private final CommandContextFactory<C> commandContextFactory = new StandardCommandContextFactory();
    private final ServicePipeline servicePipeline = ServicePipeline.builder().build();
    private final ParserRegistry<C> parserRegistry = new StandardParserRegistry();
    private final Collection<Command<C>> commands = new LinkedList<Command<C>>();
    private final ParameterInjectorRegistry<C> parameterInjectorRegistry = new ParameterInjectorRegistry();
    private final CommandExecutionCoordinator<C> commandExecutionCoordinator;
    private final CommandTree<C> commandTree;
    private final CommandSuggestionEngine<C> commandSuggestionEngine;
    private final Set<CloudCapability> capabilities = new HashSet<CloudCapability>();
    private CaptionVariableReplacementHandler captionVariableReplacementHandler = new SimpleCaptionVariableReplacementHandler();
    private CommandSyntaxFormatter<C> commandSyntaxFormatter = new StandardCommandSyntaxFormatter();
    private CommandSuggestionProcessor<C> commandSuggestionProcessor = new FilteringCommandSuggestionProcessor(FilteringCommandSuggestionProcessor.Filter.startsWith(true));
    private CommandRegistrationHandler commandRegistrationHandler;
    private CaptionRegistry<C> captionRegistry;
    private final AtomicReference<RegistrationState> state = new AtomicReference<RegistrationState>(RegistrationState.BEFORE_REGISTRATION);

    protected CommandManager(@NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull CommandRegistrationHandler commandRegistrationHandler) {
        this.commandTree = CommandTree.newTree(this);
        this.commandExecutionCoordinator = commandExecutionCoordinator.apply(this.commandTree);
        this.commandRegistrationHandler = commandRegistrationHandler;
        this.commandSuggestionEngine = new DelegatingCommandSuggestionEngineFactory(this).create();
        this.servicePipeline.registerServiceType(new TypeToken<CommandPreprocessor<C>>(){}, new AcceptingCommandPreprocessor());
        this.servicePipeline.registerServiceType(new TypeToken<CommandPostprocessor<C>>(){}, new AcceptingCommandPostprocessor());
        this.captionRegistry = new SimpleCaptionRegistryFactory().create();
        this.parameterInjectorRegistry().registerInjector(CommandContext.class, (context, annotationAccessor) -> context);
    }

    public @NonNull CompletableFuture<CommandResult<C>> executeCommand(@NonNull C commandSender, @NonNull String input) {
        CommandContext<C> context = this.commandContextFactory.create(false, commandSender, this);
        LinkedList<String> inputQueue = new CommandInputTokenizer(input).tokenize();
        context.store("__raw_input__", new LinkedList<String>(inputQueue));
        try {
            if (this.preprocessContext(context, inputQueue) == State.ACCEPTED) {
                return this.commandExecutionCoordinator.coordinateExecution(context, inputQueue);
            }
        }
        catch (Exception e) {
            CompletableFuture<CommandResult<C>> future = new CompletableFuture<CommandResult<C>>();
            future.completeExceptionally(e);
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    public @NonNull List<@NonNull String> suggest(@NonNull C commandSender, @NonNull String input) {
        CommandContext<C> context = this.commandContextFactory.create(true, commandSender, this);
        return this.commandSuggestionEngine.getSuggestions(context, input);
    }

    public @NonNull @This CommandManager<C> command(@NonNull Command<C> command) {
        if (!this.transitionIfPossible(RegistrationState.BEFORE_REGISTRATION, RegistrationState.REGISTERING) && !this.isCommandRegistrationAllowed()) {
            throw new IllegalStateException("Unable to register commands because the manager is no longer in a registration state. Your platform may allow unsafe registrations by enabling the appropriate manager setting.");
        }
        this.commandTree.insertCommand(command);
        this.commands.add(command);
        return this;
    }

    public @NonNull CommandManager<C> command(@NonNull Command.Builder<C> command) {
        return this.command(command.manager(this).build());
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull CaptionVariableReplacementHandler captionVariableReplacementHandler() {
        return this.captionVariableReplacementHandler;
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public void captionVariableReplacementHandler(@NonNull CaptionVariableReplacementHandler captionVariableReplacementHandler) {
        this.captionVariableReplacementHandler = captionVariableReplacementHandler;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public @NonNull CommandSyntaxFormatter<C> getCommandSyntaxFormatter() {
        return this.commandSyntaxFormatter();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull CommandSyntaxFormatter<C> commandSyntaxFormatter() {
        return this.commandSyntaxFormatter;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public void setCommandSyntaxFormatter(@NonNull CommandSyntaxFormatter<C> commandSyntaxFormatter) {
        this.commandSyntaxFormatter(commandSyntaxFormatter);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public void commandSyntaxFormatter(@NonNull CommandSyntaxFormatter<C> commandSyntaxFormatter) {
        this.commandSyntaxFormatter = commandSyntaxFormatter;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public @NonNull CommandRegistrationHandler getCommandRegistrationHandler() {
        return this.commandRegistrationHandler();
    }

    public @NonNull CommandRegistrationHandler commandRegistrationHandler() {
        return this.commandRegistrationHandler;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    protected final void setCommandRegistrationHandler(@NonNull CommandRegistrationHandler commandRegistrationHandler) {
        this.commandRegistrationHandler(commandRegistrationHandler);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    protected final void commandRegistrationHandler(@NonNull CommandRegistrationHandler commandRegistrationHandler) {
        this.requireState(RegistrationState.BEFORE_REGISTRATION);
        this.commandRegistrationHandler = commandRegistrationHandler;
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    protected final void registerCapability(@NonNull CloudCapability capability) {
        this.capabilities.add(capability);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public boolean hasCapability(@NonNull CloudCapability capability) {
        return this.capabilities.contains(capability);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull Collection<@NonNull CloudCapability> capabilities() {
        return Collections.unmodifiableSet(new HashSet<CloudCapability>(this.capabilities));
    }

    public boolean hasPermission(@NonNull C sender, @NonNull CommandPermission permission) {
        if (permission instanceof Permission) {
            if (permission.toString().isEmpty()) {
                return true;
            }
            return this.hasPermission(sender, permission.toString());
        }
        if (permission instanceof PredicatePermission) {
            return ((PredicatePermission)permission).hasPermission(sender);
        }
        if (permission instanceof OrPermission) {
            for (CommandPermission innerPermission : permission.getPermissions()) {
                if (!this.hasPermission(sender, innerPermission)) continue;
                return true;
            }
            return false;
        }
        if (permission instanceof AndPermission) {
            for (CommandPermission innerPermission : permission.getPermissions()) {
                if (this.hasPermission(sender, innerPermission)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown permission type " + permission.getClass());
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final @NonNull CaptionRegistry<C> getCaptionRegistry() {
        return this.captionRegistry();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final @NonNull CaptionRegistry<C> captionRegistry() {
        return this.captionRegistry;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final void setCaptionRegistry(@NonNull CaptionRegistry<C> captionRegistry) {
        this.captionRegistry(captionRegistry);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final void captionRegistry(@NonNull CaptionRegistry<C> captionRegistry) {
        this.captionRegistry = captionRegistry;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public final void registerDefaultCaptions(@NonNull CaptionRegistry<C> captionRegistry) {
        this.captionRegistry = captionRegistry;
    }

    public abstract boolean hasPermission(@NonNull C var1, @NonNull String var2);

    @API(status=API.Status.EXPERIMENTAL, since="1.7.0")
    public void deleteRootCommand(@NonNull String rootCommand) throws CloudCapability.CloudCapabilityMissingException {
        if (!this.hasCapability(CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION)) {
            throw new CloudCapability.CloudCapabilityMissingException(CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
        }
        CommandTree.Node<@Nullable CommandArgument<C, ?>> node = this.commandTree.getNamedNode(rootCommand);
        if (node == null) {
            return;
        }
        this.commandRegistrationHandler.unregisterRootCommand((StaticArgument)node.getValue());
        this.commandTree.deleteRecursively(node, true, this.commands::remove);
        this.commandTree.verifyAndRegister();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull Collection<@NonNull String> rootCommands() {
        return this.commandTree.getRootNodes().stream().map(CommandTree.Node::getValue).filter(arg -> arg instanceof StaticArgument).map(arg -> (StaticArgument)arg).map(CommandArgument::getName).collect(Collectors.toList());
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull Description description, @NonNull CommandMeta meta) {
        return this.commandBuilder(name, aliases, (ArgumentDescription)description, meta);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull ArgumentDescription description, @NonNull CommandMeta meta) {
        return Command.newBuilder(name, meta, description, aliases.toArray(new String[0])).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull CommandMeta meta) {
        return Command.newBuilder(name, meta, ArgumentDescription.empty(), aliases.toArray(new String[0])).manager(this);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, @NonNull Description description, String ... aliases) {
        return this.commandBuilder(name, meta, (ArgumentDescription)description, aliases);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, @NonNull ArgumentDescription description, String ... aliases) {
        return Command.newBuilder(name, meta, description, aliases).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, String ... aliases) {
        return Command.newBuilder(name, meta, ArgumentDescription.empty(), aliases).manager(this);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Description description, String ... aliases) {
        return this.commandBuilder(name, (ArgumentDescription)description, aliases);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull ArgumentDescription description, String ... aliases) {
        return Command.newBuilder(name, this.createDefaultCommandMeta(), description, aliases).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, String ... aliases) {
        return Command.newBuilder(name, this.createDefaultCommandMeta(), ArgumentDescription.empty(), aliases).manager(this);
    }

    public <T> @NonNull CommandArgument.Builder<C, T> argumentBuilder(@NonNull Class<T> type, @NonNull String name) {
        return CommandArgument.ofType(type, name).manager(this);
    }

    public @NonNull CommandFlag.Builder<Void> flagBuilder(@NonNull String name) {
        return CommandFlag.builder(name);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public @NonNull CommandTree<C> getCommandTree() {
        return this.commandTree();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull CommandTree<C> commandTree() {
        return this.commandTree;
    }

    public abstract @NonNull CommandMeta createDefaultCommandMeta();

    public void registerCommandPreProcessor(@NonNull CommandPreprocessor<C> processor) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<CommandPreprocessor<C>>(){}, processor, Collections.emptyList());
    }

    public void registerCommandPostProcessor(@NonNull CommandPostprocessor<C> processor) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<CommandPostprocessor<C>>(){}, processor, Collections.emptyList());
    }

    public State preprocessContext(@NonNull CommandContext<C> context, @NonNull LinkedList<@NonNull String> inputQueue) {
        this.servicePipeline.pump(new CommandPreprocessingContext<C>(context, inputQueue)).through(new TypeToken<CommandPreprocessor<C>>(){}).getResult();
        return context.getOptional("__COMMAND_PRE_PROCESSED__").orElse("").isEmpty() ? State.REJECTED : State.ACCEPTED;
    }

    public State postprocessContext(@NonNull CommandContext<C> context, @NonNull Command<C> command) {
        this.servicePipeline.pump(new CommandPostprocessingContext<C>(context, command)).through(new TypeToken<CommandPostprocessor<C>>(){}).getResult();
        return context.getOptional("__COMMAND_POST_PROCESSED__").orElse("").isEmpty() ? State.REJECTED : State.ACCEPTED;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public @NonNull CommandSuggestionProcessor<C> getCommandSuggestionProcessor() {
        return this.commandSuggestionProcessor();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull CommandSuggestionProcessor<C> commandSuggestionProcessor() {
        return this.commandSuggestionProcessor;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public void setCommandSuggestionProcessor(@NonNull CommandSuggestionProcessor<C> commandSuggestionProcessor) {
        this.commandSuggestionProcessor(commandSuggestionProcessor);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public void commandSuggestionProcessor(@NonNull CommandSuggestionProcessor<C> commandSuggestionProcessor) {
        this.commandSuggestionProcessor = commandSuggestionProcessor;
    }

    @Deprecated
    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull ParserRegistry<C> getParserRegistry() {
        return this.parserRegistry();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull ParserRegistry<C> parserRegistry() {
        return this.parserRegistry;
    }

    public final @NonNull ParameterInjectorRegistry<C> parameterInjectorRegistry() {
        return this.parameterInjectorRegistry;
    }

    public final <E extends Exception> @Nullable BiConsumer<@NonNull C, @NonNull E> getExceptionHandler(@NonNull Class<E> clazz) {
        BiConsumer<C, ? extends Exception> consumer = this.exceptionHandlers.get(clazz);
        if (consumer == null) {
            return null;
        }
        return consumer;
    }

    public final <E extends Exception> void registerExceptionHandler(@NonNull Class<E> clazz, @NonNull BiConsumer<@NonNull C, @NonNull E> handler) {
        this.exceptionHandlers.put(clazz, handler);
    }

    public final <E extends Exception> void handleException(@NonNull C sender, @NonNull Class<E> clazz, @NonNull E exception, @NonNull BiConsumer<C, E> defaultHandler) {
        Optional.ofNullable(this.getExceptionHandler(clazz)).orElse(defaultHandler).accept(sender, exception);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final @NonNull Collection<@NonNull Command<C>> getCommands() {
        return this.commands();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final @NonNull Collection<@NonNull Command<C>> commands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final @NonNull CommandHelpHandler<C> getCommandHelpHandler() {
        return this.createCommandHelpHandler();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final @NonNull CommandHelpHandler<C> createCommandHelpHandler() {
        return new CommandHelpHandler(this, cmd -> true);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final @NonNull CommandHelpHandler<C> getCommandHelpHandler(@NonNull Predicate<Command<C>> commandPredicate) {
        return this.createCommandHelpHandler(commandPredicate);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final @NonNull CommandHelpHandler<C> createCommandHelpHandler(@NonNull Predicate<Command<C>> commandPredicate) {
        return new CommandHelpHandler<C>(this, commandPredicate);
    }

    public boolean getSetting(@NonNull ManagerSettings setting) {
        return this.managerSettings.contains((Object)setting);
    }

    public void setSetting(@NonNull ManagerSettings setting, boolean value) {
        if (value) {
            this.managerSettings.add(setting);
        } else {
            this.managerSettings.remove((Object)setting);
        }
    }

    @API(status=API.Status.STABLE, since="1.6.0")
    public @NonNull CommandExecutionCoordinator<C> commandExecutionCoordinator() {
        return this.commandExecutionCoordinator;
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    protected final void transitionOrThrow(@NonNull RegistrationState in, @NonNull RegistrationState out) {
        if (!this.transitionIfPossible(in, out)) {
            throw new IllegalStateException("Command manager was in state " + (Object)((Object)this.state.get()) + ", while we were expecting a state of " + (Object)((Object)in) + " or " + (Object)((Object)out) + "!");
        }
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    protected final boolean transitionIfPossible(@NonNull RegistrationState in, @NonNull RegistrationState out) {
        return this.state.compareAndSet(in, out) || this.state.get() == out;
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    protected final void requireState(@NonNull RegistrationState expected) {
        if (this.state.get() != expected) {
            throw new IllegalStateException("This operation required the commands manager to be in state " + (Object)((Object)expected) + ", but it was in " + (Object)((Object)this.state.get()) + " instead!");
        }
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    protected final void lockRegistration() {
        if (this.registrationState() == RegistrationState.BEFORE_REGISTRATION) {
            this.transitionOrThrow(RegistrationState.BEFORE_REGISTRATION, RegistrationState.AFTER_REGISTRATION);
            return;
        }
        this.transitionOrThrow(RegistrationState.REGISTERING, RegistrationState.AFTER_REGISTRATION);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7.0")
    public final @NonNull RegistrationState getRegistrationState() {
        return this.registrationState();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public final @NonNull RegistrationState registrationState() {
        return this.state.get();
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    public boolean isCommandRegistrationAllowed() {
        return this.getSetting(ManagerSettings.ALLOW_UNSAFE_REGISTRATION) || this.state.get() != RegistrationState.AFTER_REGISTRATION;
    }

    @API(status=API.Status.STABLE)
    public static enum ManagerSettings {
        ENFORCE_INTERMEDIARY_PERMISSIONS,
        FORCE_SUGGESTION,
        ALLOW_UNSAFE_REGISTRATION,
        OVERRIDE_EXISTING_COMMANDS,
        LIBERAL_FLAG_PARSING;

    }

    @API(status=API.Status.STABLE, since="1.2.0")
    public static enum RegistrationState {
        BEFORE_REGISTRATION,
        REGISTERING,
        AFTER_REGISTRATION;

    }
}

