/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.annotations.injection;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import net.cufufy.pronouns.shadow.cloud.annotations.AnnotationAccessor;
import net.cufufy.pronouns.shadow.cloud.annotations.injection.InjectionService;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.types.tuples.Triplet;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.4.0")
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull Triplet<CommandContext<C>, Class<?>, AnnotationAccessor> triplet) {
        try {
            return this.injector.getInstance(triplet.getSecond());
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

