/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.annotations.injection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.cufufy.pronouns.shadow.cloud.annotations.AnnotationAccessor;
import net.cufufy.pronouns.shadow.cloud.annotations.injection.InjectionService;
import net.cufufy.pronouns.shadow.cloud.annotations.injection.ParameterInjector;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.services.ServicePipeline;
import net.cufufy.pronouns.shadow.cloud.types.tuples.Pair;
import net.cufufy.pronouns.shadow.cloud.types.tuples.Triplet;
import net.cufufy.pronouns.shadow.geantyref.TypeToken;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.2.0")
public final class ParameterInjectorRegistry<C>
implements InjectionService<C> {
    private final List<Pair<Predicate<Class<?>>, ParameterInjector<C, ?>>> injectors = new ArrayList();
    private final ServicePipeline servicePipeline = ServicePipeline.builder().build();

    public ParameterInjectorRegistry() {
        this.servicePipeline.registerServiceType(new TypeToken<InjectionService<C>>(){}, this);
    }

    public synchronized <T> void registerInjector(@NonNull Class<T> clazz, @NonNull ParameterInjector<C, T> injector) {
        this.registerInjector((Class<?> cl) -> cl.isAssignableFrom(clazz), injector);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public synchronized <T> void registerInjector(@NonNull Predicate<Class<?>> predicate, @NonNull ParameterInjector<C, T> injector) {
        this.injectors.add(Pair.of(predicate, injector));
    }

    @Deprecated
    public synchronized <T> @NonNull Collection<@NonNull ParameterInjector<C, ?>> injectors(@NonNull Class<T> clazz) {
        return Collections.unmodifiableCollection(this.injectors.stream().filter(pair -> ((Predicate)pair.getFirst()).test(clazz)).map(Pair::getSecond).collect(Collectors.toList()));
    }

    @Override
    public @Nullable Object handle(@NonNull Triplet<CommandContext<C>, Class<?>, AnnotationAccessor> triplet) {
        for (ParameterInjector<C, ?> injector : this.injectors(triplet.getSecond())) {
            Object value = injector.create(triplet.getFirst(), triplet.getThird());
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> @NonNull Optional<T> getInjectable(@NonNull Class<T> clazz, @NonNull CommandContext<C> context, @NonNull AnnotationAccessor annotationAccessor) {
        Triplet<CommandContext<C>, Class<T>, AnnotationAccessor> triplet = Triplet.of(context, clazz, annotationAccessor);
        try {
            return Optional.of(clazz.cast(this.servicePipeline.pump(triplet).through(new TypeToken<InjectionService<C>>(){}).getResult()));
        }
        catch (IllegalStateException illegalStateException) {
            return Optional.empty();
        }
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public void registerInjectionService(InjectionService<C> service) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<InjectionService<C>>(){}, service, Collections.emptyList());
    }
}

