/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.arguments.standard;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.cufufy.pronouns.shadow.cloud.ArgumentDescription;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ArgumentParseResult;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ArgumentParser;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionVariable;
import net.cufufy.pronouns.shadow.cloud.captions.StandardCaptionKeys;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.exceptions.parsing.NoInputProvidedException;
import net.cufufy.pronouns.shadow.cloud.exceptions.parsing.ParserException;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.7.0")
public final class DurationArgument<C>
extends CommandArgument<C, Duration> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(([1-9][0-9]+|[1-9])[dhms])");

    private DurationArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, Duration.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull DurationArgument<C> of(@NonNull String name) {
        return ((Builder)DurationArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull DurationArgument<C> optional(@NonNull String name) {
        return ((Builder)DurationArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull DurationArgument<C> optional(@NonNull String name, @NonNull String defaultDuration) {
        return ((Builder)DurationArgument.builder(name).asOptionalWithDefault(defaultDuration)).build();
    }

    public static <C> @NonNull DurationArgument<C> optional(@NonNull String name, @NonNull Duration defaultDuration) {
        return DurationArgument.builder(name).asOptionalWithDefault(defaultDuration).build();
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static final class Parser<C>
    implements ArgumentParser<C, Duration> {
        @Override
        public @NonNull ArgumentParseResult<Duration> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(DurationParseException.class, commandContext));
            }
            Matcher matcher = DURATION_PATTERN.matcher(input);
            Duration duration = Duration.ofNanos(0L);
            block12: while (matcher.find()) {
                String group = matcher.group();
                String timeUnit = String.valueOf(group.charAt(group.length() - 1));
                int timeValue = Integer.parseInt(group.substring(0, group.length() - 1));
                switch (timeUnit) {
                    case "d": {
                        duration = duration.plusDays(timeValue);
                        continue block12;
                    }
                    case "h": {
                        duration = duration.plusHours(timeValue);
                        continue block12;
                    }
                    case "m": {
                        duration = duration.plusMinutes(timeValue);
                        continue block12;
                    }
                    case "s": {
                        duration = duration.plusSeconds(timeValue);
                        continue block12;
                    }
                }
                return ArgumentParseResult.failure(new DurationParseException(input, commandContext));
            }
            if (duration.isZero()) {
                return ArgumentParseResult.failure(new DurationParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(duration);
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            char[] chars = input.toLowerCase(Locale.ROOT).toCharArray();
            if (chars.length == 0) {
                return IntStream.range(1, 10).boxed().sorted().map(String::valueOf).collect(Collectors.toList());
            }
            char last = chars[chars.length - 1];
            if (Character.isLetter(last)) {
                return Collections.emptyList();
            }
            return Stream.of("d", "h", "m", "s").filter(unit -> !input.contains((CharSequence)unit)).map((? super T unit) -> input + unit).collect(Collectors.toList());
        }
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, Duration, Builder<C>> {
        private Builder(@NonNull String name) {
            super(Duration.class, name);
        }

        public @NonNull Builder<C> asOptionalWithDefault(@NonNull Duration defaultValue) {
            return (Builder)this.asOptionalWithDefault(defaultValue.getSeconds() + "s");
        }

        public @NonNull DurationArgument<C> build() {
            return new DurationArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static final class DurationParseException
    extends ParserException {
        private static final long serialVersionUID = 7632293268451349508L;
        private final String input;

        public DurationParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(Parser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_DURATION, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

