/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.bukkit;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.cufufy.pronouns.shadow.cloud.captions.Caption;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitCaptionKeys {
    private static final Collection<Caption> RECOGNIZED_CAPTIONS = new LinkedList<Caption>();
    public static final Caption ARGUMENT_PARSE_FAILURE_ENCHANTMENT = BukkitCaptionKeys.of("argument.parse.failure.enchantment");
    public static final Caption ARGUMENT_PARSE_FAILURE_MATERIAL = BukkitCaptionKeys.of("argument.parse.failure.material");
    public static final Caption ARGUMENT_PARSE_FAILURE_OFFLINEPLAYER = BukkitCaptionKeys.of("argument.parse.failure.offlineplayer");
    public static final Caption ARGUMENT_PARSE_FAILURE_PLAYER = BukkitCaptionKeys.of("argument.parse.failure.player");
    public static final Caption ARGUMENT_PARSE_FAILURE_WORLD = BukkitCaptionKeys.of("argument.parse.failure.world");
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static final Caption ARGUMENT_PARSE_FAILURE_SELECTOR_MALFORMED = BukkitCaptionKeys.of("argument.parse.failure.selector.malformed");
    public static final Caption ARGUMENT_PARSE_FAILURE_SELECTOR_UNSUPPORTED = BukkitCaptionKeys.of("argument.parse.failure.selector.unsupported");
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static final Caption ARGUMENT_PARSE_FAILURE_SELECTOR_TOO_MANY_PLAYERS = BukkitCaptionKeys.of("argument.parse.failure.selector.too_many_players");
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static final Caption ARGUMENT_PARSE_FAILURE_SELECTOR_TOO_MANY_ENTITIES = BukkitCaptionKeys.of("argument.parse.failure.selector.too_many_entities");
    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static final Caption ARGUMENT_PARSE_FAILURE_SELECTOR_NON_PLAYER = BukkitCaptionKeys.of("argument.parse.failure.selector.non_player_in_player_selector");
    public static final Caption ARGUMENT_PARSE_FAILURE_LOCATION_INVALID_FORMAT = BukkitCaptionKeys.of("argument.parse.failure.location.invalid_format");
    public static final Caption ARGUMENT_PARSE_FAILURE_LOCATION_MIXED_LOCAL_ABSOLUTE = BukkitCaptionKeys.of("argument.parse.failure.location.mixed_local_absolute");
    public static final Caption ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NAMESPACE = BukkitCaptionKeys.of("argument.parse.failure.namespacedkey.namespace");
    public static final Caption ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY = BukkitCaptionKeys.of("argument.parse.failure.namespacedkey.key");
    public static final Caption ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NEED_NAMESPACE = BukkitCaptionKeys.of("argument.parse.failure.namespacedkey.need_namespace");

    private BukkitCaptionKeys() {
    }

    private static @NonNull Caption of(@NonNull String key) {
        Caption caption = Caption.of(key);
        RECOGNIZED_CAPTIONS.add(caption);
        return caption;
    }

    public static @NonNull Collection<@NonNull Caption> getBukkitCaptionKeys() {
        return Collections.unmodifiableCollection(RECOGNIZED_CAPTIONS);
    }
}

