/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.bukkit;

import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCommandContextKeys;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCommandManager;
import net.cufufy.pronouns.shadow.cloud.bukkit.CloudBukkitCapabilities;
import net.cufufy.pronouns.shadow.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import net.cufufy.pronouns.shadow.cloud.execution.preprocessor.CommandPreprocessingContext;
import net.cufufy.pronouns.shadow.cloud.execution.preprocessor.CommandPreprocessor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BukkitCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private final BukkitCommandManager<C> commandManager;
    private final @Nullable BukkitBackwardsBrigadierSenderMapper<C, ?> mapper;

    BukkitCommandPreprocessor(@NonNull BukkitCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.mapper = this.commandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER) ? new BukkitBackwardsBrigadierSenderMapper(this.commandManager) : null;
    }

    @Override
    public void accept(@NonNull CommandPreprocessingContext<C> context) {
        if (this.mapper != null && !context.getCommandContext().contains("_cloud_brigadier_native_sender")) {
            context.getCommandContext().store("_cloud_brigadier_native_sender", this.mapper.apply(context.getCommandContext().getSender()));
        }
        context.getCommandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, this.commandManager.getBackwardsCommandSenderMapper().apply(context.getCommandContext().getSender()));
        context.getCommandContext().store(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES, this.commandManager.queryCapabilities());
    }
}

