/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.cufufy.pronouns.shadow.cloud.Command;
import net.cufufy.pronouns.shadow.cloud.CommandManager;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.StaticArgument;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCommand;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCommandManager;
import net.cufufy.pronouns.shadow.cloud.bukkit.CloudBukkitCapabilities;
import net.cufufy.pronouns.shadow.cloud.bukkit.CloudCommodoreManager;
import net.cufufy.pronouns.shadow.cloud.internal.CommandRegistrationHandler;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.help.GenericCommandHelpTopic;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private final Map<CommandArgument<?, ?>, org.bukkit.command.Command> registeredCommands = new HashMap();
    private final Set<String> recognizedAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, org.bukkit.command.Command> bukkitCommands;
    private BukkitCommandManager<C> bukkitCommandManager;
    private CommandMap commandMap;

    protected BukkitPluginRegistrationHandler() {
    }

    final void initialize(@NonNull BukkitCommandManager<C> bukkitCommandManager) throws Exception {
        Map bukkitCommands;
        Method getCommandMap = Bukkit.getServer().getClass().getDeclaredMethod("getCommandMap", new Class[0]);
        getCommandMap.setAccessible(true);
        this.commandMap = (CommandMap)getCommandMap.invoke((Object)Bukkit.getServer(), new Object[0]);
        Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommands.setAccessible(true);
        this.bukkitCommands = bukkitCommands = (Map)knownCommands.get(this.commandMap);
        this.bukkitCommandManager = bukkitCommandManager;
        Bukkit.getHelpMap().registerHelpTopicFactory(BukkitCommand.class, GenericCommandHelpTopic::new);
    }

    @Override
    public final boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument<?, ?> commandArgument = command.getArguments().get(0);
        if (!(this.bukkitCommandManager.commandRegistrationHandler() instanceof CloudCommodoreManager) && this.registeredCommands.containsKey(commandArgument)) {
            return false;
        }
        String label = commandArgument.getName();
        String namespacedLabel = this.getNamespacedLabel(label);
        ArrayList<String> aliases = new ArrayList<String>(((StaticArgument)commandArgument).getAlternativeAliases());
        BukkitCommand bukkitCommand = new BukkitCommand(label, aliases, command, commandArgument, this.bukkitCommandManager);
        if (this.bukkitCommandManager.getSetting(CommandManager.ManagerSettings.OVERRIDE_EXISTING_COMMANDS)) {
            this.bukkitCommands.remove(label);
            aliases.forEach(this.bukkitCommands::remove);
        }
        HashSet<String> newAliases = new HashSet<String>();
        for (String alias2 : aliases) {
            String namespacedAlias = this.getNamespacedLabel(alias2);
            newAliases.add(namespacedAlias);
            if (this.bukkitCommandOrAliasExists(alias2)) continue;
            newAliases.add(alias2);
        }
        if (!this.bukkitCommandExists(label)) {
            newAliases.add(label);
        }
        newAliases.add(namespacedLabel);
        this.commandMap.register(label, this.bukkitCommandManager.getOwningPlugin().getName().toLowerCase(), bukkitCommand);
        this.recognizedAliases.addAll(newAliases);
        if (this.bukkitCommandManager.getSplitAliases()) {
            newAliases.forEach(alias -> this.registerExternal((String)alias, command, bukkitCommand));
        }
        this.registeredCommands.put(commandArgument, bukkitCommand);
        return true;
    }

    @Override
    public final void unregisterRootCommand(@NonNull StaticArgument<?> rootCommand) {
        org.bukkit.command.Command registeredCommand = this.registeredCommands.get(rootCommand);
        if (registeredCommand == null) {
            return;
        }
        ((BukkitCommand)registeredCommand).disable();
        ArrayList<String> aliases = new ArrayList<String>(rootCommand.getAlternativeAliases());
        HashSet<String> registeredAliases = new HashSet<String>();
        for (String alias : aliases) {
            registeredAliases.add(this.getNamespacedLabel(alias));
            if (!this.bukkitCommandOrAliasExists(alias)) continue;
            registeredAliases.add(alias);
        }
        if (this.bukkitCommandExists(rootCommand.getName())) {
            registeredAliases.add(rootCommand.getName());
        }
        registeredAliases.add(this.getNamespacedLabel(rootCommand.getName()));
        this.bukkitCommands.remove(rootCommand.getName());
        this.bukkitCommands.remove(this.getNamespacedLabel(rootCommand.getName()));
        this.recognizedAliases.removeAll(registeredAliases);
        if (this.bukkitCommandManager.getSplitAliases()) {
            registeredAliases.forEach(this::unregisterExternal);
        }
        this.registeredCommands.remove(rootCommand);
        if (this.bukkitCommandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
        }
    }

    private @NonNull String getNamespacedLabel(@NonNull String label) {
        return String.format("%s:%s", this.bukkitCommandManager.getOwningPlugin().getName(), label).toLowerCase();
    }

    public boolean isRecognized(@NonNull String alias) {
        return this.recognizedAliases.contains(alias);
    }

    protected void registerExternal(@NonNull String label, @NonNull Command<?> command, @NonNull BukkitCommand<C> bukkitCommand) {
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    protected void unregisterExternal(@NonNull String label) {
    }

    private boolean bukkitCommandExists(String commandLabel) {
        org.bukkit.command.Command existingCommand = this.bukkitCommands.get(commandLabel);
        if (existingCommand == null) {
            return false;
        }
        if (existingCommand instanceof PluginIdentifiableCommand) {
            return existingCommand.getLabel().equals(commandLabel) && !((PluginIdentifiableCommand)existingCommand).getPlugin().getName().equalsIgnoreCase(this.bukkitCommandManager.getOwningPlugin().getName());
        }
        return existingCommand.getLabel().equals(commandLabel);
    }

    private boolean bukkitCommandOrAliasExists(String commandLabel) {
        org.bukkit.command.Command command = this.bukkitCommands.get(commandLabel);
        if (command instanceof PluginIdentifiableCommand) {
            return !((PluginIdentifiableCommand)command).getPlugin().getName().equalsIgnoreCase(this.bukkitCommandManager.getOwningPlugin().getName());
        }
        return command != null;
    }
}

