/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.bukkit.argument;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import net.cufufy.pronouns.shadow.cloud.ArgumentDescription;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ArgumentParseResult;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ArgumentParser;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCaptionKeys;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitCommandManager;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitParserParameters;
import net.cufufy.pronouns.shadow.cloud.captions.Caption;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionVariable;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.exceptions.parsing.ParserException;
import net.cufufy.pronouns.shadow.geantyref.TypeToken;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NamespacedKeyArgument<C>
extends CommandArgument<C, NamespacedKey> {
    private NamespacedKeyArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, boolean requireExplicitNamespace, String defaultNamespace) {
        super(required, name, new Parser(requireExplicitNamespace, defaultNamespace), defaultValue, NamespacedKey.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull NamespacedKeyArgument<C> of(@NonNull String name) {
        return ((Builder)NamespacedKeyArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull NamespacedKeyArgument<C> optional(@NonNull String name) {
        return ((Builder)NamespacedKeyArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull NamespacedKeyArgument<C> optional(@NonNull String name, @NonNull NamespacedKey defulatValue) {
        return NamespacedKeyArgument.builder(name).asOptionalWithDefault(defulatValue).build();
    }

    private static <C> void registerParserSupplier(@NonNull BukkitCommandManager<C> commandManager) {
        commandManager.parserRegistry().registerParserSupplier(TypeToken.get(NamespacedKey.class), params -> new Parser(params.has(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE), params.get(BukkitParserParameters.DEFAULT_NAMESPACE, "minecraft")));
    }

    public static final class Parser<C>
    implements ArgumentParser<C, NamespacedKey> {
        private final boolean requireExplicitNamespace;
        private final String defaultNamespace;

        public Parser(boolean requireExplicitNamespace, String defaultNamespace) {
            this.requireExplicitNamespace = requireExplicitNamespace;
            this.defaultNamespace = defaultNamespace;
        }

        @Override
        public @NonNull ArgumentParseResult<NamespacedKey> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            int maxSemi;
            String input = inputQueue.peek();
            String[] split = input.split(":");
            int n = maxSemi = split.length > 1 ? 1 : 0;
            if (input.length() - input.replace(":", "").length() > maxSemi) {
                return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY, input, commandContext));
            }
            try {
                NamespacedKey ret;
                if (split.length == 1) {
                    if (this.requireExplicitNamespace) {
                        return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NEED_NAMESPACE, input, commandContext));
                    }
                    ret = new NamespacedKey(this.defaultNamespace, split[0]);
                } else if (split.length == 2) {
                    ret = new NamespacedKey(split[0], split[1]);
                } else {
                    return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY, input, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(ret);
            }
            catch (IllegalArgumentException ex) {
                Caption caption = ex.getMessage().contains("namespace") ? BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NAMESPACE : BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY;
                return ArgumentParseResult.failure(new NamespacedKeyParseException(caption, input, commandContext));
            }
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.defaultNamespace + ":");
            if (!input.contains(":") && !input.isEmpty()) {
                ret.add(input + ":");
            }
            return ret;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, NamespacedKey, Builder<C>> {
        private boolean requireExplicitNamespace = false;
        private String defaultNamespace = "minecraft";

        private Builder(@NonNull String name) {
            super(NamespacedKey.class, name);
        }

        public Builder<C> requireExplicitNamespace() {
            return this.requireExplicitNamespace(true);
        }

        public Builder<C> requireExplicitNamespace(boolean requireExplicitNamespace) {
            this.requireExplicitNamespace = requireExplicitNamespace;
            return this;
        }

        public Builder<C> defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public Builder<C> asOptionalWithDefault(NamespacedKey defaultValue) {
            return (Builder)this.asOptionalWithDefault(defaultValue.getNamespace() + ':' + defaultValue.getKey());
        }

        public @NonNull NamespacedKeyArgument<C> build() {
            return new NamespacedKeyArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription(), this.requireExplicitNamespace, this.defaultNamespace);
        }
    }

    public static final class NamespacedKeyParseException
    extends ParserException {
        private static final long serialVersionUID = -482592639358941441L;
        private final String input;

        public NamespacedKeyParseException(@NonNull Caption caption, @NonNull String input, @NonNull CommandContext<?> context) {
            super(Parser.class, context, caption, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespacedKeyParseException that = (NamespacedKeyParseException)o;
            return this.input.equals(that.input) && this.errorCaption().equals(that.errorCaption());
        }

        public int hashCode() {
            return Objects.hash(this.input, this.errorCaption());
        }
    }
}

