/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.bukkit.parsers.selector;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import net.cufufy.pronouns.shadow.cloud.ArgumentDescription;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.parser.ArgumentParseResult;
import net.cufufy.pronouns.shadow.cloud.bukkit.arguments.selector.SinglePlayerSelector;
import net.cufufy.pronouns.shadow.cloud.bukkit.parsers.PlayerArgument;
import net.cufufy.pronouns.shadow.cloud.bukkit.parsers.selector.SelectorUtils;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SinglePlayerSelectorArgument<C>
extends CommandArgument<C, SinglePlayerSelector> {
    private SinglePlayerSelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new SinglePlayerSelectorParser(), defaultValue, SinglePlayerSelector.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return SinglePlayerSelectorArgument.builder(name);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull SinglePlayerSelectorArgument<C> of(@NonNull String name) {
        return ((Builder)SinglePlayerSelectorArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull SinglePlayerSelectorArgument<C> optional(@NonNull String name) {
        return ((Builder)SinglePlayerSelectorArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull SinglePlayerSelectorArgument<C> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return ((Builder)SinglePlayerSelectorArgument.builder(name).asOptionalWithDefault(defaultEntitySelector)).build();
    }

    public static final class SinglePlayerSelectorParser<C>
    extends SelectorUtils.PlayerSelectorParser<C, SinglePlayerSelector> {
        public SinglePlayerSelectorParser() {
            super(true);
        }

        @Override
        public SinglePlayerSelector mapResult(@NonNull String input, @NonNull SelectorUtils.EntitySelectorWrapper wrapper) {
            return new SinglePlayerSelector(input, Collections.singletonList(wrapper.singlePlayer()));
        }

        @Override
        protected @NonNull ArgumentParseResult<SinglePlayerSelector> legacyParse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            @Nullable Player player = Bukkit.getPlayer((String)input);
            if (player == null) {
                return ArgumentParseResult.failure(new PlayerArgument.PlayerParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(new SinglePlayerSelector(input, (List<Entity>)ImmutableList.of((Object)player)));
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, SinglePlayerSelector, Builder<C>> {
        private Builder(@NonNull String name) {
            super(SinglePlayerSelector.class, name);
        }

        public @NonNull SinglePlayerSelectorArgument<C> build() {
            return new SinglePlayerSelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

