/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.cufufy.pronouns.shadow.cloud.CommandManager;
import net.cufufy.pronouns.shadow.cloud.annotations.AnnotationAccessor;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.arguments.flags.FlagContext;
import net.cufufy.pronouns.shadow.cloud.captions.Caption;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionRegistry;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionVariable;
import net.cufufy.pronouns.shadow.cloud.captions.CaptionVariableReplacementHandler;
import net.cufufy.pronouns.shadow.cloud.captions.SimpleCaptionVariableReplacementHandler;
import net.cufufy.pronouns.shadow.cloud.keys.CloudKey;
import net.cufufy.pronouns.shadow.cloud.keys.CloudKeyHolder;
import net.cufufy.pronouns.shadow.cloud.keys.SimpleCloudKey;
import net.cufufy.pronouns.shadow.cloud.permission.CommandPermission;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public class CommandContext<C> {
    private final CaptionVariableReplacementHandler captionVariableReplacementHandler;
    private final Map<CommandArgument<C, ?>, ArgumentTiming> argumentTimings = new HashMap();
    private final FlagContext flagContext = FlagContext.create();
    private final Map<CloudKey<?>, Object> internalStorage = new HashMap();
    private final C commandSender;
    private final boolean suggestions;
    private final CaptionRegistry<C> captionRegistry;
    private final CommandManager<C> commandManager;
    private CommandArgument<C, ?> currentArgument = null;

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.3.0")
    public CommandContext(@NonNull C commandSender, @NonNull CaptionRegistry<C> captionRegistry) {
        this(false, commandSender, captionRegistry);
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public CommandContext(@NonNull C commandSender, @NonNull CommandManager<C> commandManager) {
        this(false, commandSender, commandManager);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.3.0")
    public CommandContext(boolean suggestions, @NonNull C commandSender, @NonNull CaptionRegistry<C> captionRegistry) {
        this.commandSender = commandSender;
        this.suggestions = suggestions;
        this.captionRegistry = captionRegistry;
        this.captionVariableReplacementHandler = new SimpleCaptionVariableReplacementHandler();
        this.commandManager = null;
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public CommandContext(boolean suggestions, @NonNull C commandSender, @NonNull CommandManager<C> commandManager) {
        this.commandSender = commandSender;
        this.suggestions = suggestions;
        this.commandManager = commandManager;
        this.captionRegistry = commandManager.captionRegistry();
        this.captionVariableReplacementHandler = commandManager.captionVariableReplacementHandler();
    }

    public @NonNull String formatMessage(@NonNull Caption caption, CaptionVariable ... variables) {
        return this.captionVariableReplacementHandler.replaceVariables(this.captionRegistry.getCaption(caption, this.commandSender), variables);
    }

    public @NonNull C getSender() {
        return this.commandSender;
    }

    @API(status=API.Status.STABLE, since="1.6.0")
    public boolean hasPermission(@NonNull CommandPermission permission) {
        return this.commandManager.hasPermission(this.commandSender, permission);
    }

    @API(status=API.Status.STABLE, since="1.6.0")
    public boolean hasPermission(@NonNull String permission) {
        return this.commandManager.hasPermission(this.commandSender, permission);
    }

    public boolean isSuggestions() {
        return this.suggestions;
    }

    public <T> void store(@NonNull String key, T value) {
        this.internalStorage.put(SimpleCloudKey.of(key), value);
    }

    public <T> void store(@NonNull CloudKey<T> key, T value) {
        this.internalStorage.put(key, value);
    }

    public <T> void store(@NonNull CommandArgument<C, T> keyHolder, T value) {
        this.store((CloudKeyHolder<T>)keyHolder, value);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> void store(@NonNull CloudKeyHolder<T> keyHolder, T value) {
        this.internalStorage.put(keyHolder.getKey(), value);
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public <T> void set(@NonNull String key, @Nullable T value) {
        if (value != null) {
            this.store(key, value);
        } else {
            this.remove(key);
        }
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> void set(@NonNull CloudKey<T> key, @Nullable T value) {
        if (value != null) {
            this.store(key, value);
        } else {
            this.remove(key);
        }
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public boolean contains(@NonNull String key) {
        return this.contains(SimpleCloudKey.of(key));
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public boolean contains(@NonNull CloudKey<?> key) {
        return this.internalStorage.containsKey(key);
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public @NonNull Map<@NonNull String, @Nullable ?> asMap() {
        HashMap values = new HashMap();
        this.internalStorage.forEach((key, value) -> values.put(key.getName(), value));
        return Collections.unmodifiableMap(values);
    }

    public <T> @NonNull Optional<T> getOptional(@NonNull String key) {
        Object value = this.internalStorage.get(SimpleCloudKey.of(key));
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> @NonNull Optional<T> getOptional(@NonNull CloudKey<T> key) {
        Object value = this.internalStorage.get(key);
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    public <T> @NonNull Optional<T> getOptional(@NonNull CommandArgument<C, T> keyHolder) {
        return this.getOptional((CloudKeyHolder<T>)keyHolder);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> @NonNull Optional<T> getOptional(@NonNull CloudKeyHolder<T> keyHolder) {
        Object value = this.internalStorage.get(keyHolder.getKey());
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    public void remove(@NonNull String key) {
        this.remove(SimpleCloudKey.of(key));
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public void remove(@NonNull CloudKey<?> key) {
        this.internalStorage.remove(key);
    }

    public <T> T get(@NonNull String key) {
        Object value = this.internalStorage.get(SimpleCloudKey.of(key));
        if (value == null) {
            throw new NullPointerException("No such object stored in the context: " + key);
        }
        return (T)value;
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> T get(@NonNull CloudKey<T> key) {
        Object value = this.internalStorage.get(key);
        if (value == null) {
            throw new NullPointerException("No such object stored in the context: " + key);
        }
        return (T)value;
    }

    public <T> T get(@NonNull CommandArgument<C, T> keyHolder) {
        return this.get(keyHolder.getKey());
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> T get(@NonNull CloudKeyHolder<T> keyHolder) {
        return this.get(keyHolder.getKey());
    }

    public <T> T getOrDefault(@NonNull CommandArgument<C, @NonNull T> argument, T defaultValue) {
        return this.getOptional(argument.getName()).orElse(defaultValue);
    }

    public <T> T getOrDefault(@NonNull String key, T defaultValue) {
        return this.getOptional(key).orElse(defaultValue);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> T getOrDefault(@NonNull CloudKey<@NonNull T> key, T defaultValue) {
        return this.getOptional(key).orElse(defaultValue);
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    public <T> T getOrSupplyDefault(@NonNull String key, @NonNull Supplier<T> defaultSupplier) {
        return this.getOptional(key).orElseGet(defaultSupplier);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public <T> T getOrSupplyDefault(@NonNull CloudKey<@NonNull T> key, @NonNull Supplier<T> defaultSupplier) {
        return this.getOptional(key).orElseGet(defaultSupplier);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public <T> T computeIfAbsent(@NonNull CloudKey<T> key, @NonNull Function<CloudKey<T>, T> defaultFunction) {
        Object castedValue = this.internalStorage.computeIfAbsent(key, (? super K k) -> defaultFunction.apply((CloudKey)k));
        return (T)castedValue;
    }

    public @NonNull LinkedList<@NonNull String> getRawInput() {
        return this.getOrDefault("__raw_input__", new LinkedList());
    }

    @API(status=API.Status.STABLE, since="1.1.0")
    public @NonNull String getRawInputJoined() {
        return String.join((CharSequence)" ", this.getRawInput());
    }

    public @NonNull ArgumentTiming createTiming(@NonNull CommandArgument<C, ?> argument) {
        ArgumentTiming argumentTiming = new ArgumentTiming();
        this.argumentTimings.put(argument, argumentTiming);
        return argumentTiming;
    }

    public @NonNull Map<CommandArgument<@NonNull C, @NonNull ?>, ArgumentTiming> getArgumentTimings() {
        return Collections.unmodifiableMap(this.argumentTimings);
    }

    public @NonNull FlagContext flags() {
        return this.flagContext;
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    public @Nullable CommandArgument<C, ?> getCurrentArgument() {
        return this.currentArgument;
    }

    @API(status=API.Status.STABLE, since="1.2.0")
    public void setCurrentArgument(@Nullable CommandArgument<C, ?> argument) {
        this.currentArgument = argument;
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public <T> @NonNull Optional<T> inject(@NonNull Class<T> clazz) {
        if (this.commandManager == null) {
            throw new UnsupportedOperationException("Cannot retrieve injectable values from a command context that is not associated with a command manager");
        }
        return this.commandManager.parameterInjectorRegistry().getInjectable(clazz, this, AnnotationAccessor.empty());
    }

    @API(status=API.Status.STABLE)
    public static final class ArgumentTiming {
        private long start;
        private long end;
        private boolean success;

        public ArgumentTiming(long start, long end, boolean success) {
            this.start = start;
            this.end = end;
            this.success = success;
        }

        public ArgumentTiming(long start) {
            this(start, -1L, false);
        }

        public ArgumentTiming() {
            this(-1L, -1L, false);
        }

        public long getElapsedTime() {
            if (this.end == -1L) {
                throw new IllegalStateException("No end time has been registered");
            }
            if (this.start == -1L) {
                throw new IllegalStateException("No start time has been registered");
            }
            return this.end - this.start;
        }

        public void setEnd(long end, boolean success) {
            this.end = end;
            this.success = success;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public boolean wasSuccess() {
            return this.success;
        }
    }
}

