/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.exceptions;

import java.util.List;
import net.cufufy.pronouns.shadow.cloud.arguments.CommandArgument;
import net.cufufy.pronouns.shadow.cloud.exceptions.CommandParseException;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class NoSuchCommandException
extends CommandParseException {
    private static final long serialVersionUID = -7775865652882764771L;
    private final String suppliedCommand;

    @API(status=API.Status.INTERNAL, consumers={"net.cufufy.pronouns.shadow.cloud.*"})
    public NoSuchCommandException(@NonNull Object commandSender, @NonNull List<CommandArgument<?, ?>> currentChain, @NonNull String command) {
        super(commandSender, currentChain);
        this.suppliedCommand = command;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (CommandArgument<?, ?> commandArgument : this.getCurrentChain()) {
            if (commandArgument == null) continue;
            builder.append(" ").append(commandArgument.getName());
        }
        return String.format("Unrecognized command input '%s' following chain%s", this.suppliedCommand, builder.toString());
    }

    public @NonNull String getSuppliedCommand() {
        return this.suppliedCommand;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        return this;
    }
}

