/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.paper;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Method;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.cufufy.pronouns.shadow.cloud.CommandTree;
import net.cufufy.pronouns.shadow.cloud.brigadier.CloudBrigadierManager;
import net.cufufy.pronouns.shadow.cloud.bukkit.BukkitBrigadierMapper;
import net.cufufy.pronouns.shadow.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import net.cufufy.pronouns.shadow.cloud.context.CommandContext;
import net.cufufy.pronouns.shadow.cloud.paper.PaperBrigadierMapper;
import net.cufufy.pronouns.shadow.cloud.paper.PaperCommandManager;
import net.cufufy.pronouns.shadow.cloud.permission.CommandPermission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class PaperBrigadierListener<C>
implements Listener {
    private static final @Nullable Method SET_RAW;
    private final CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager;
    private final PaperCommandManager<C> paperCommandManager;

    PaperBrigadierListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
        this.brigadierManager = new CloudBrigadierManager(this.paperCommandManager, () -> new CommandContext(this.paperCommandManager.getCommandSenderMapper().apply((CommandSender)Bukkit.getConsoleSender()), this.paperCommandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.paperCommandManager.getCommandSenderMapper().apply(sender.getBukkitSender()));
        new PaperBrigadierMapper<C>(new BukkitBrigadierMapper<C>(this.paperCommandManager, this.brigadierManager));
        this.brigadierManager.backwardsBrigadierSenderMapper(new BukkitBackwardsBrigadierSenderMapper(this.paperCommandManager));
    }

    protected @NonNull CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager() {
        return this.brigadierManager;
    }

    @EventHandler
    public void onCommandRegister(@NonNull CommandRegisteredEvent<BukkitBrigadierCommandSource> event) {
        String label;
        if (!(event.getCommand() instanceof PluginIdentifiableCommand)) {
            return;
        }
        if (!((PluginIdentifiableCommand)event.getCommand()).getPlugin().equals(this.paperCommandManager.getOwningPlugin())) {
            return;
        }
        CommandTree commandTree = this.paperCommandManager.commandTree();
        CommandTree.Node node = commandTree.getNamedNode(label = event.getCommandLabel().contains(":") ? event.getCommandLabel().split(Pattern.quote(":"))[1] : event.getCommandLabel());
        if (node == null) {
            return;
        }
        BiPredicate<BukkitBrigadierCommandSource, CommandPermission> permissionChecker = (s2, p) -> {
            if (commandTree.getNamedNode(label) == null) {
                return false;
            }
            Object sender = this.paperCommandManager.getCommandSenderMapper().apply(s2.getBukkitSender());
            return this.paperCommandManager.hasPermission(sender, (CommandPermission)p);
        };
        event.setLiteral(this.brigadierManager.createLiteralCommandNode(node, (LiteralCommandNode<BukkitBrigadierCommandSource>)event.getLiteral(), (SuggestionProvider<BukkitBrigadierCommandSource>)event.getBrigadierCommand(), (Command<BukkitBrigadierCommandSource>)event.getBrigadierCommand(), permissionChecker));
        if (SET_RAW != null) {
            try {
                SET_RAW.invoke(event, true);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static {
        Method mth;
        try {
            mth = CommandRegisteredEvent.class.getDeclaredMethod("setRawCommand", Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            mth = null;
        }
        SET_RAW = mth;
    }
}

