/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.permission;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.cufufy.pronouns.shadow.cloud.permission.AndPermission;
import net.cufufy.pronouns.shadow.cloud.permission.OrPermission;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface CommandPermission {
    public @NonNull Collection<@NonNull CommandPermission> getPermissions();

    public String toString();

    @API(status=API.Status.STABLE, since="1.4.0")
    default public @NonNull CommandPermission or(@NonNull CommandPermission other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(2);
        permission.add(this);
        permission.add(other);
        return OrPermission.of(permission);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    default public @NonNull CommandPermission or(CommandPermission ... other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(other.length + 1);
        permission.add(this);
        permission.addAll(Arrays.asList(other));
        return OrPermission.of(permission);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    default public @NonNull CommandPermission and(@NonNull CommandPermission other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(2);
        permission.add(this);
        permission.add(other);
        return AndPermission.of(permission);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    default public @NonNull CommandPermission and(CommandPermission ... other) {
        Objects.requireNonNull(other, "other");
        HashSet<CommandPermission> permission = new HashSet<CommandPermission>(other.length + 1);
        permission.add(this);
        permission.addAll(Arrays.asList(other));
        return AndPermission.of(permission);
    }
}

