/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.services;

import java.util.function.Predicate;
import net.cufufy.pronouns.shadow.cloud.services.PipelineException;
import net.cufufy.pronouns.shadow.cloud.services.types.Service;
import net.cufufy.pronouns.shadow.geantyref.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes( @NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.getFilters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

