/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.shadow.cloud.types.tuples;

import java.util.Objects;
import net.cufufy.pronouns.shadow.cloud.types.tuples.Tuple;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public class Triplet<U, V, W>
implements Tuple {
    private final U first;
    private final V second;
    private final W third;

    protected Triplet(@NonNull U first, @NonNull V second, @NonNull W third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <U, V, W> @NonNull Triplet<@NonNull U, @NonNull V, @NonNull W> of(@NonNull U first, @NonNull V second, @NonNull W third) {
        return new Triplet<U, V, W>(first, second, third);
    }

    public final U getFirst() {
        return this.first;
    }

    public final V getSecond() {
        return this.second;
    }

    public final W getThird() {
        return this.third;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triplet triplet = (Triplet)o;
        return Objects.equals(this.getFirst(), triplet.getFirst()) && Objects.equals(this.getSecond(), triplet.getSecond()) && Objects.equals(this.getThird(), triplet.getThird());
    }

    public final int hashCode() {
        return Objects.hash(this.getFirst(), this.getSecond(), this.getThird());
    }

    public final String toString() {
        return String.format("(%s, %s, %s)", this.first, this.second, this.third);
    }

    @Override
    public final int getSize() {
        return 3;
    }

    @Override
    public final @NonNull Object @NonNull [] toArray() {
        Object[] array = new Object[]{this.first, this.second, this.third};
        return array;
    }
}

