/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.nightvision;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class Nightvision
extends JavaPlugin
implements Listener,
CommandExecutor {
    private final MiniMessage mm = MiniMessage.miniMessage();
    private FileConfiguration config;
    private final Set<UUID> nightVisionPlayers = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("nv").setExecutor((CommandExecutor)this);
        this.getCommand("nvlist").setExecutor((CommandExecutor)this);
    }

    public void onDisable() {
        this.nightVisionPlayers.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.nightVisionPlayers.contains(player.getUniqueId())) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false, false));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("nv")) {
            if (!player.hasPermission("nv.use")) {
                player.sendActionBar(this.mm.deserialize((Object)this.config.getString("messages.no-permission", "<red>You have no permission to use this command!</red>")));
                return true;
            }
            UUID uuid = player.getUniqueId();
            if (this.nightVisionPlayers.contains(uuid)) {
                this.nightVisionPlayers.remove(uuid);
                player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                player.sendActionBar(this.mm.deserialize((Object)this.config.getString("messages.nv-disabled", "<gray>Night vision <red>disabled</red>.</gray>")));
            } else {
                this.nightVisionPlayers.add(uuid);
                player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false, false));
                player.sendActionBar(this.mm.deserialize((Object)this.config.getString("messages.nv-enabled", "<gray>Night vision <green>enabled</green>.</gray>")));
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("nvlist")) {
            if (!player.hasPermission("nv.list")) {
                player.sendActionBar(this.mm.deserialize((Object)this.config.getString("messages.nvlist-permission", "<red>You have no permission to use /nvlist!</red>")));
                return true;
            }
            player.sendMessage(this.mm.deserialize((Object)("<aqua>The users of /nv are: (<gold>" + this.nightVisionPlayers.size() + "</gold><aqua>)")));
            player.sendMessage(this.mm.deserialize((Object)"<gray>-------------------</gray>"));
            int count = 0;
            for (UUID uuid : this.nightVisionPlayers) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null || !p.isOnline()) continue;
                player.sendMessage(this.mm.deserialize((Object)("<gray>" + ++count + ". <aqua>" + p.getName())));
            }
            return true;
        }
        return false;
    }
}

