/*
 *    This file is part of the Distant Horizons mod
 *    licensed under the GNU LGPL v3 License.
 *
 *    Copyright (C) 2020 James Seibel
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Lesser General Public License as published by
 *    the Free Software Foundation, version 3.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.seibel.distanthorizons.api.enums.rendering;

/**
 * LINEAR,				<br>
 * EXPONENTIAL, 		<br>
 * EXPONENTIAL_SQUARED 	<br>
 *
 * @author Leetom
 * @version 2024-11-09
 * @since API 2.0.0
 */
public enum EDhApiFogFalloff
{
	// Reminder:
	// when adding items up the API minor version
	// when removing items up the API major version
	
	
	LINEAR(0),
	EXPONENTIAL(1),
	EXPONENTIAL_SQUARED(2);
	
	
	/** 
	 * Stable version of {@link EDhApiFogFalloff#ordinal()} 
	 * @since API 4.0.0
	 */
	public final int value;
	
	EDhApiFogFalloff(int value) { this.value = value; }
	
}
