/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.brigadier.argument;

import com.mojang.brigadier.StringReader;
import java.util.Deque;
import java.util.Queue;

final class QueueAsStringReader
extends StringReader {
    private boolean closed;
    private final Queue<String> input;

    QueueAsStringReader(Queue<String> input) {
        super(String.join((CharSequence)" ", input));
        this.input = input;
    }

    void updateQueue() {
        String next;
        if (this.closed) {
            throw new IllegalStateException("double-closed");
        }
        this.closed = true;
        for (int idx = this.getCursor(); idx > 0; idx -= next.length() + 1) {
            next = this.input.element();
            this.input.remove();
            if (idx >= next.length()) {
                continue;
            }
            if (!(this.input instanceof Deque)) {
                throw new IllegalArgumentException();
            }
            ((Deque)this.input).addFirst(next.substring(idx));
            break;
        }
    }
}

