/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.Command;
import cloud.commandframework.CommandTree;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import org.apiguardian.api.API;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BukkitCommand<C>
extends org.bukkit.command.Command
implements PluginIdentifiableCommand {
    private static final String MESSAGE_INTERNAL_ERROR = ChatColor.RED + "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = ChatColor.RED + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final CommandArgument<C, ?> command;
    private final BukkitCommandManager<C> manager;
    private final Command<C> cloudCommand;
    private boolean disabled;

    BukkitCommand(@NonNull String label, @NonNull List<@NonNull String> aliases, @NonNull Command<C> cloudCommand, @NonNull CommandArgument<C, ?> command, @NonNull BukkitCommandManager<C> manager) {
        super(label, cloudCommand.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, ""), "", aliases);
        this.command = command;
        this.manager = manager;
        this.cloudCommand = cloudCommand;
        if (this.command.getOwningCommand() != null) {
            this.setPermission(this.command.getOwningCommand().getCommandPermission().toString());
        }
        this.disabled = false;
    }

    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String alias, @NonNull String @NonNull [] args) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : args) {
            builder.append(" ").append(string);
        }
        return this.manager.suggest(this.manager.getCommandSenderMapper().apply(sender), builder.toString());
    }

    public boolean execute(@NonNull CommandSender commandSender, @NonNull String s2, @NonNull String @NonNull [] strings) {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        C sender = this.manager.getCommandSenderMapper().apply(commandSender);
        this.manager.executeCommand(sender, builder.toString()).whenComplete((commandResult, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(sender, InvalidSyntaxException.class, (InvalidSyntaxException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + "Invalid Command Syntax. Correct command syntax is: " + ChatColor.GRAY + "/" + ((InvalidSyntaxException)finalThrowable).getCorrectSyntax()));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    this.manager.handleException(sender, InvalidCommandSenderException.class, (InvalidCommandSenderException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + finalThrowable.getMessage()));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(sender, NoPermissionException.class, (NoPermissionException)throwable, (c, e) -> commandSender.sendMessage(MESSAGE_NO_PERMS));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(sender, NoSuchCommandException.class, (NoSuchCommandException)throwable, (c, e) -> commandSender.sendMessage(MESSAGE_UNKNOWN_COMMAND));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(sender, ArgumentParseException.class, (ArgumentParseException)throwable, (c, e) -> commandSender.sendMessage(ChatColor.RED + "Invalid Command Argument: " + ChatColor.GRAY + finalThrowable.getCause().getMessage()));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(sender, CommandExecutionException.class, (CommandExecutionException)throwable, (c, e) -> {
                        commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                        this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "Exception executing command handler", finalThrowable.getCause());
                    });
                } else {
                    commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                    this.manager.getOwningPlugin().getLogger().log(Level.SEVERE, "An unhandled exception was thrown during command execution", (Throwable)throwable);
                }
            }
        });
        return true;
    }

    public @NonNull String getDescription() {
        return this.cloudCommand.getCommandMeta().getOrDefault(CommandMeta.DESCRIPTION, "");
    }

    public @NonNull Plugin getPlugin() {
        return this.manager.getOwningPlugin();
    }

    public @NonNull String getUsage() {
        return this.manager.commandSyntaxFormatter().apply(Collections.singletonList(Objects.requireNonNull(this.namedNode().getValue())), this.namedNode());
    }

    public boolean testPermissionSilent(@NonNull CommandSender target) {
        CommandTree.Node<CommandArgument<C, ?>> node = this.namedNode();
        if (this.disabled || node == null) {
            return false;
        }
        CommandPermission permission = (CommandPermission)node.getNodeMeta().getOrDefault("permission", Permission.empty());
        return this.manager.hasPermission(this.manager.getCommandSenderMapper().apply(target), permission);
    }

    @API(status=API.Status.INTERNAL, since="1.7.0")
    void disable() {
        this.disabled = true;
    }

    public boolean isRegistered() {
        return !this.disabled;
    }

    private  @Nullable CommandTree.Node<CommandArgument<C, ?>> namedNode() {
        return this.manager.commandTree().getNamedNode(this.command.getName());
    }
}

