/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.exceptions.parsing;

import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.StandardCaptionKeys;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.ParserException;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public abstract class NumberParseException
extends ParserException {
    private static final long serialVersionUID = 3018775374056029797L;
    private final String input;
    private final Number min;
    private final Number max;

    protected NumberParseException(@NonNull String input, @NonNull Number min2, @NonNull Number max, @NonNull Class<?> parserClass, @NonNull CommandContext<?> context) {
        super(parserClass, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NUMBER, CaptionVariable.of("input", input), CaptionVariable.of("min", String.valueOf(min2)), CaptionVariable.of("max", String.valueOf(max)));
        this.input = input;
        this.min = min2;
        this.max = max;
    }

    public abstract @NonNull String getNumberType();

    public abstract boolean hasMax();

    public abstract boolean hasMin();

    public @NonNull String getInput() {
        return this.input;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }
}

