/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime;

import net.ezplace.deathTime.commands.DeathTimeCommands;
import net.ezplace.deathTime.config.MessagesManager;
import net.ezplace.deathTime.config.SettingsManager;
import net.ezplace.deathTime.core.ItemManager;
import net.ezplace.deathTime.core.PlayerManager;
import net.ezplace.deathTime.data.BatchProcessor;
import net.ezplace.deathTime.data.CacheManager;
import net.ezplace.deathTime.data.DatabaseManager;
import net.ezplace.deathTime.listeners.EntityListener;
import net.ezplace.deathTime.listeners.PlayerListener;
import net.ezplace.deathTime.other.DeathTimePlaceholders;
import net.ezplace.deathTime.tasks.BanTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DeathTime
extends JavaPlugin {
    private DatabaseManager databaseManager;
    private CacheManager cacheManager;
    private BatchProcessor batchProcessor;
    private BanTask banTask;
    private static DeathTime instance;
    private ItemManager itemHandler;
    private PlayerManager playerManager;

    public void onEnable() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe(MessagesManager.getInstance().getMessage("plugin.classnotfound.h2") + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        this.itemHandler = new ItemManager((Plugin)this);
        this.getLogger().info("\nVersion: 1.0.0");
        this.getDataFolder().mkdirs();
        SettingsManager.getInstance().load();
        MessagesManager.getInstance().loadMessages();
        try {
            this.playerManager = new PlayerManager();
            this.databaseManager = new DatabaseManager(this.getDataFolder());
            this.cacheManager = new CacheManager(this.databaseManager, this);
            this.batchProcessor = new BatchProcessor(this.databaseManager, (Plugin)this);
            this.banTask = new BanTask(this, this.cacheManager, this.databaseManager);
            DeathTimeCommands commandExecutor = new DeathTimeCommands(this.itemHandler, this.cacheManager);
            this.getCommand("deathtime").setExecutor((CommandExecutor)commandExecutor);
            this.getCommand("deathtime").setTabCompleter((TabCompleter)commandExecutor);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.cacheManager, this.batchProcessor, this.itemHandler), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this.itemHandler, this.playerManager, this.cacheManager), (Plugin)this);
            this.getLogger().info(MessagesManager.getInstance().getMessage("plugin.enabled"));
            this.startScheduledTasks();
        }
        catch (Exception e) {
            this.getLogger().severe(MessagesManager.getInstance().getMessage("plugin.disable") + e.getMessage());
            e.printStackTrace();
            this.setEnabled(false);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new DeathTimePlaceholders(this).register();
            this.getLogger().info(MessagesManager.getInstance().getMessage("plugin.enable.papi"));
        }
    }

    private void startScheduledTasks() {
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            this.cacheManager.decrementAllTimers();
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, this.batchProcessor::flushBatch);
        }, 0L, 20L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.banTask.checkExpiredBans(), 0L, 1200L);
    }

    public void onDisable() {
        if (this.batchProcessor != null) {
            this.batchProcessor.getInstance().shutdown();
        }
        if (this.cacheManager != null) {
            this.cacheManager.flushAllToDatabase();
        }
    }

    public static DeathTime getInstance() {
        return instance;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

