/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ezplace.deathTime.DeathTime;
import net.ezplace.deathTime.config.SettingsManager;
import net.ezplace.deathTime.other.ColorUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesManager {
    private static MessagesManager instance = new MessagesManager();
    private YamlConfiguration messages;
    private Map<String, String> messageCache = new HashMap<String, String>();

    private MessagesManager() {
    }

    public static MessagesManager getInstance() {
        return instance;
    }

    public void loadMessages() {
        File file;
        File langFolder = new File(DeathTime.getInstance().getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(file = new File(langFolder, SettingsManager.LANGUAGE + ".yml")).exists()) {
            DeathTime.getInstance().saveResource("lang/" + SettingsManager.LANGUAGE + ".yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        this.messageCache.clear();
        this.messages.getKeys(true).forEach(key -> this.messageCache.put((String)key, this.messages.getString(key, key)));
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.messageCache.getOrDefault(key, key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return ColorUtils.translateRGB(message);
    }

    public List<String> getMessageList(String key, Map<String, String> placeholders) {
        ArrayList<String> formattedList = new ArrayList<String>();
        List rawList = this.messages.getStringList(key);
        Iterator iterator = rawList.iterator();
        while (iterator.hasNext()) {
            String line;
            String formattedLine = line = (String)iterator.next();
            if (placeholders != null) {
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    formattedLine = formattedLine.replace("{" + entry.getKey() + "}", entry.getValue());
                }
            }
            formattedList.add(ColorUtils.translateRGB(formattedLine));
        }
        return formattedList;
    }

    public String getMessage(String key) {
        return this.getMessage(key, null);
    }
}

