/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.ezplace.deathTime.DeathTime;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SettingsManager {
    private static final SettingsManager instance = new SettingsManager();
    private File file;
    private YamlConfiguration config;
    public static String LANGUAGE;
    public static String DATABASE_TYPE;
    public static String DATABASE_HOST;
    public static int DATABASE_PORT;
    public static String DATABASE_NAME;
    public static String DATABASE_USERNAME;
    public static String DATABASE_PASSWORD;
    public static int DATABASE_POOLSIZE;
    public static int DATABASE_CONNTIMEOUT;
    public static int CACHE_EXPIRATION;
    public static int CACHE_SIZE;
    public static Long INITIAL_TIME;
    public static Long BAN_DURATION;
    public static Material ITEM_MATERIAL;
    public static String ITEM_NAME;
    public static String ITEM_LORE;
    public static int KILL_COOLDOWN;
    public static int PLAYER_ON_DEATH_PENALTY;
    public static boolean PLAYER_NATURAL_DEATH_DROP;
    public static Map<String, Integer> REWARDS;

    private SettingsManager() {
    }

    public static SettingsManager getInstance() {
        return instance;
    }

    public void load() {
        this.file = new File(DeathTime.getInstance().getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            DeathTime.getInstance().saveResource("config.yml", false);
        }
        this.config = new YamlConfiguration();
        this.config.options().parseComments(true);
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LANGUAGE = String.valueOf(this.config.getString("Lang"));
        DATABASE_TYPE = this.config.getString("Database.type", "h2");
        DATABASE_HOST = this.config.getString("Database.host", "localhost");
        DATABASE_PORT = this.config.getInt("Database.port", 3306);
        DATABASE_NAME = this.config.getString("Database.database_name", "deathtimer");
        DATABASE_USERNAME = this.config.getString("Database.username", "root");
        DATABASE_PASSWORD = this.config.getString("Database.password", "password");
        DATABASE_POOLSIZE = this.config.getInt("Config.port", 3306);
        DATABASE_CONNTIMEOUT = this.config.getInt("Config.port", 3306);
        CACHE_EXPIRATION = this.config.getInt("Config.cacheExpiration", 30);
        CACHE_SIZE = this.config.getInt("Config.cacheSize", 1000);
        INITIAL_TIME = this.config.getLong("Defaults.Initial-time", 11340L);
        BAN_DURATION = this.config.getLong("Defaults.Ban-duration", 11340L);
        ITEM_MATERIAL = Material.valueOf((String)this.config.getString("Defaults.Item.Material"));
        ITEM_NAME = String.valueOf(this.config.getString("Defaults.Item.Name"));
        ITEM_LORE = String.valueOf(this.config.getString("Defaults.Item.Lore"));
        KILL_COOLDOWN = this.config.getInt("Defaults.Kill-cooldown", 300);
        PLAYER_ON_DEATH_PENALTY = this.config.getInt("Defaults.Player-on-death-penalty", 300);
        PLAYER_NATURAL_DEATH_DROP = this.config.getBoolean("Defaults.Player-natural-death-drop", false);
        REWARDS.clear();
        ConfigurationSection rewardsSection = this.config.getConfigurationSection("Rewards.Entities");
        if (rewardsSection != null) {
            for (String entity : rewardsSection.getKeys(false)) {
                REWARDS.put(entity, rewardsSection.getInt(entity));
            }
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.save();
    }

    static {
        REWARDS = new HashMap<String, Integer>();
    }
}

