/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.core;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.ezplace.deathTime.config.SettingsManager;

public class PlayerManager {
    private final ConcurrentHashMap<String, AtomicLong> lastKillTimes = new ConcurrentHashMap();

    public boolean canDropItem(UUID killer, UUID victim) {
        String key = killer.toString() + "_" + victim.toString();
        long currentTime = System.currentTimeMillis() / 1000L;
        AtomicLong lastTime = this.lastKillTimes.get(key);
        if (lastTime == null) {
            this.lastKillTimes.put(key, new AtomicLong(currentTime));
            return true;
        }
        long elapsed = currentTime - lastTime.get();
        return elapsed >= (long)SettingsManager.KILL_COOLDOWN;
    }

    public void updateCooldown(UUID killer, UUID victim) {
        String key = killer.toString() + "_" + victim.toString();
        this.lastKillTimes.put(key, new AtomicLong(System.currentTimeMillis() / 1000L));
    }
}

