/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.data;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.ezplace.deathTime.data.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class BatchProcessor {
    private final DatabaseManager dbManager;
    private final Map<UUID, Long> batchQueue = new ConcurrentHashMap<UUID, Long>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final Plugin plugin;

    public BatchProcessor(DatabaseManager dbManager, Plugin plugin) {
        this.dbManager = dbManager;
        this.plugin = plugin;
        this.scheduler.scheduleAtFixedRate(this::flushBatch, 5L, 5L, TimeUnit.SECONDS);
    }

    public BatchProcessor getInstance() {
        return this;
    }

    public void addToBatch(UUID uuid, Long time) {
        try {
            this.batchQueue.put(uuid, time);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[ERROR] Failed to add to batch for user: " + String.valueOf(uuid), e);
        }
    }

    public void flushBatch() {
        if (this.batchQueue.isEmpty()) {
            return;
        }
        this.batchQueue.forEach(this.dbManager::updatePlayerTime);
        this.batchQueue.clear();
    }

    public void flushSingle(UUID uuid) {
        Long time = this.batchQueue.get(uuid);
        if (time != null) {
            this.dbManager.updatePlayerTime(uuid, time);
            this.batchQueue.remove(uuid);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.flushBatch();
    }
}

