/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.ezplace.deathTime.DeathTime;
import net.ezplace.deathTime.config.SettingsManager;
import net.ezplace.deathTime.data.BatchProcessor;
import net.ezplace.deathTime.data.DatabaseManager;
import net.ezplace.deathTime.tasks.BanTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CacheManager {
    private final DatabaseManager db;
    private final LoadingCache<UUID, Long> timersCache;
    private final Plugin plugin;
    private final BanTask banTask;
    private final BatchProcessor batchProcessor;
    private final CacheManager cacheManager;
    private final Set<UUID> bypassedPlayers = ConcurrentHashMap.newKeySet();

    public CacheManager(DatabaseManager db, DeathTime plugin) {
        this.db = db;
        this.plugin = plugin;
        this.cacheManager = this;
        this.banTask = new BanTask(plugin, this.cacheManager, db);
        this.batchProcessor = new BatchProcessor(db, (Plugin)plugin);
        this.timersCache = Caffeine.newBuilder().maximumSize(SettingsManager.CACHE_SIZE).expireAfterAccess(SettingsManager.CACHE_EXPIRATION, TimeUnit.MINUTES).build(this::loadFromDatabase);
    }

    private Long loadFromDatabase(UUID uuid) {
        return this.db.getPlayerTime(uuid);
    }

    public void decrementAllTimers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            long time;
            UUID uuid = player.getUniqueId();
            if (this.hasBypass(uuid) || (time = this.getPlayerTime(uuid).longValue()) <= 0L) continue;
            long newTime = time - 1L;
            this.timersCache.put(uuid, newTime);
            this.batchProcessor.addToBatch(uuid, newTime);
            if (newTime > 0L) continue;
            Bukkit.getScheduler().runTask(this.plugin, () -> this.banTask.banPlayer(uuid));
        }
    }

    public void flushAllToDatabase() {
        this.timersCache.asMap().forEach(this.db::updatePlayerTime);
    }

    public Long getPlayerTime(UUID uuid) {
        Long time = (Long)this.timersCache.getIfPresent(uuid);
        if (time == null) {
            time = this.db.getPlayerTime(uuid);
            if (time < 0L) {
                time = (long)SettingsManager.INITIAL_TIME;
                this.db.updatePlayerTime(uuid, time);
            }
            this.timersCache.put(uuid, time);
        }
        return time;
    }

    public void validateTimers() {
        for (UUID uuid : this.timersCache.asMap().keySet()) {
            boolean isBanned;
            long currentTime = this.timersCache.get(uuid);
            if (currentTime < 0L) {
                Bukkit.getLogger().warning("Tiempo negativo detectado para " + String.valueOf(uuid) + ". Corrigiendo a 0.");
                this.timersCache.put(uuid, 0L);
                Bukkit.getScheduler().runTask(this.plugin, () -> this.banTask.banPlayer(uuid));
            }
            if ((isBanned = this.db.isPlayerBanned(uuid)) && currentTime > 0L) {
                Bukkit.getLogger().warning("Inconsistencia: Jugador " + String.valueOf(uuid) + " est\u00e1 baneado pero tiene tiempo positivo. Restableciendo.");
                this.db.updateBanStatus(uuid, 0L);
                this.timersCache.put(uuid, 0L);
                continue;
            }
            if (isBanned || currentTime > 0L) continue;
            Bukkit.getLogger().warning("Inconsistencia: Jugador " + String.valueOf(uuid) + " no est\u00e1 baneado pero tiene tiempo 0. Baneando.");
            Bukkit.getScheduler().runTask(this.plugin, () -> this.banTask.banPlayer(uuid));
        }
    }

    public void updatePlayerTime(UUID uuid, long time) {
        if (time < 0L) {
            time = 0L;
            Bukkit.getScheduler().runTask(this.plugin, () -> this.banTask.banPlayer(uuid));
        }
        this.timersCache.put(uuid, time);
        this.batchProcessor.addToBatch(uuid, time);
    }

    public void invalidatePlayer(UUID uuid) {
        this.timersCache.invalidate(uuid);
    }

    public boolean hasBypass(UUID uuid) {
        if (this.bypassedPlayers.contains(uuid)) {
            return true;
        }
        return this.db.isBypass(uuid);
    }

    public void addBypass(UUID uuid) {
        this.bypassedPlayers.add(uuid);
        this.db.setBypass(uuid, true);
    }

    public void removeBypass(UUID uuid) {
        this.bypassedPlayers.remove(uuid);
        this.db.setBypass(uuid, false);
    }
}

