/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.data;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.ezplace.deathTime.config.SettingsManager;
import org.bukkit.Bukkit;
import org.json.JSONObject;

public class DatabaseManager {
    private final HikariDataSource dataSource;

    public DatabaseManager(File dataFolder) {
        HikariConfig config = new HikariConfig();
        switch (SettingsManager.DATABASE_TYPE.toLowerCase()) {
            case "h2": {
                config.setJdbcUrl("jdbc:h2:" + dataFolder.getAbsolutePath() + "/" + SettingsManager.DATABASE_NAME);
                break;
            }
            case "sqlite": {
                config.setJdbcUrl("jdbc:sqlite:" + dataFolder.getAbsolutePath() + "/" + SettingsManager.DATABASE_NAME + ".db");
                break;
            }
            case "mysql": {
                config.setJdbcUrl("jdbc:mysql://" + SettingsManager.DATABASE_HOST + ":" + SettingsManager.DATABASE_PORT + "/" + SettingsManager.DATABASE_NAME);
                config.setUsername(SettingsManager.DATABASE_USERNAME);
                config.setPassword(SettingsManager.DATABASE_PASSWORD);
                break;
            }
            case "postgresql": {
                config.setJdbcUrl("jdbc:postgresql://" + SettingsManager.DATABASE_HOST + ":" + SettingsManager.DATABASE_PORT + "/" + SettingsManager.DATABASE_NAME);
                config.setUsername(SettingsManager.DATABASE_USERNAME);
                config.setPassword(SettingsManager.DATABASE_PASSWORD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de base de datos no soportado: " + SettingsManager.DATABASE_TYPE);
            }
        }
        config.setMaximumPoolSize(SettingsManager.DATABASE_POOLSIZE);
        config.setConnectionTimeout(SettingsManager.DATABASE_CONNTIMEOUT);
        this.dataSource = new HikariDataSource(config);
        this.createTables();
    }

    private void createTables() {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS players (uuid VARCHAR(36) PRIMARY KEY, username VARCHAR(16) NOT NULL, timer BIGINT NOT NULL, banned_until BIGINT DEFAULT 0, bypass BOOLEAN DEFAULT FALSE)");){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long getPlayerTime(UUID uuid) {
        try (Connection conn = this.dataSource.getConnection();){
            long l;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("SELECT timer FROM players WHERE uuid = ?");
                try {
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    long l2 = l = rs.next() ? rs.getLong("timer") : -1L;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void updatePlayerTime(UUID uuid, long time) {
        String username = Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : Bukkit.getOfflinePlayer((UUID)uuid).getName();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("MERGE INTO players(uuid, username, timer) KEY(uuid) VALUES(?, ?, ?)");){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, username);
            stmt.setLong(3, time);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateBanStatus(UUID uuid, long bannedUntil) {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE players SET banned_until = ? WHERE uuid = ?");){
            stmt.setLong(1, bannedUntil);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Map<UUID, Long> getActiveBans() {
        HashMap<UUID, Long> bans = new HashMap<UUID, Long>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT uuid, banned_until FROM players WHERE banned_until > 0");){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                bans.put(uuid, rs.getLong("banned_until"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bans;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isPlayerBanned(UUID uuid) {
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("SELECT banned_until FROM players WHERE uuid = ?");
                try {
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    boolean bl2 = bl = rs.next() && rs.getLong("banned_until") > System.currentTimeMillis();
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setBypass(UUID uuid, boolean bypass) {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE players SET bypass = ? WHERE uuid = ?");){
            stmt.setBoolean(1, bypass);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isBypass(UUID uuid) {
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("SELECT bypass FROM players WHERE uuid = ?");
                try {
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    boolean bl2 = bl = rs.next() && rs.getBoolean("bypass");
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UUID getCachedUUID(String name) {
        try (Connection conn = this.dataSource.getConnection();){
            UUID uUID;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("SELECT uuid FROM players WHERE username = ?");
                try {
                    stmt.setString(1, name);
                    ResultSet rs = stmt.executeQuery();
                    UUID uUID2 = uUID = rs.next() ? UUID.fromString(rs.getString("uuid")) : null;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UUID getUUIDFromMojang(String name) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JSONObject json = new JSONObject(response.toString());
                String uuidStr = json.getString("id");
                return UUID.fromString(uuidStr.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

