/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.listeners;

import net.ezplace.deathTime.config.SettingsManager;
import net.ezplace.deathTime.core.ItemManager;
import net.ezplace.deathTime.core.PlayerManager;
import net.ezplace.deathTime.data.CacheManager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    private final ItemManager itemManager;
    private final PlayerManager playerManager;
    private final CacheManager cacheManager;

    public EntityListener(ItemManager itemManager, PlayerManager playerManager, CacheManager cacheManager) {
        this.itemManager = itemManager;
        this.playerManager = playerManager;
        this.cacheManager = cacheManager;
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player victim = (Player)livingEntity;
            String entityType = victim.getType().toString();
            int timeToAdd = SettingsManager.REWARDS.getOrDefault(entityType, 0);
            if (timeToAdd <= 0) {
                return;
            }
            Player killer = victim.getKiller();
            if (killer == null && !SettingsManager.PLAYER_NATURAL_DEATH_DROP) {
                return;
            }
            if (killer != null && killer != victim && this.playerManager.canDropItem(killer.getUniqueId(), victim.getUniqueId())) {
                ItemStack timeItem = this.itemManager.createItem(timeToAdd);
                victim.getWorld().dropItemNaturally(victim.getLocation(), timeItem);
                this.playerManager.updateCooldown(killer.getUniqueId(), victim.getUniqueId());
            }
            long playerTime = this.cacheManager.getPlayerTime(victim.getUniqueId());
            this.cacheManager.updatePlayerTime(victim.getUniqueId(), playerTime - (long)SettingsManager.PLAYER_ON_DEATH_PENALTY);
        } else {
            LivingEntity entity = event.getEntity();
            String entityType = entity.getType().toString();
            int timeToAdd = SettingsManager.REWARDS.getOrDefault(entityType, 0);
            if (timeToAdd <= 0) {
                return;
            }
            ItemStack timeItem = this.itemManager.createItem(timeToAdd);
            entity.getWorld().dropItemNaturally(entity.getLocation(), timeItem);
        }
    }
}

