/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.listeners;

import java.util.Map;
import java.util.UUID;
import net.ezplace.deathTime.config.MessagesManager;
import net.ezplace.deathTime.config.SettingsManager;
import net.ezplace.deathTime.core.ItemManager;
import net.ezplace.deathTime.data.BatchProcessor;
import net.ezplace.deathTime.data.CacheManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    private final CacheManager cacheManager;
    private final BatchProcessor batchProcessor;
    private final ItemManager itemManager;

    public PlayerListener(CacheManager cacheManager, BatchProcessor batchProcessor, ItemManager itemManager) {
        this.cacheManager = cacheManager;
        this.batchProcessor = batchProcessor;
        this.itemManager = itemManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        long currentTime = this.cacheManager.getPlayerTime(uuid);
        this.cacheManager.getPlayerTime(uuid);
        if (currentTime <= 0L) {
            this.cacheManager.updatePlayerTime(uuid, SettingsManager.INITIAL_TIME);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.batchProcessor.flushSingle(uuid);
        this.cacheManager.invalidatePlayer(uuid);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        int timeToAdd = this.itemManager.getItemValue(item);
        if (timeToAdd > 0) {
            UUID uuid = player.getUniqueId();
            long currentTime = this.cacheManager.getPlayerTime(uuid);
            this.cacheManager.updatePlayerTime(uuid, currentTime + (long)timeToAdd);
            item.setAmount(item.getAmount() - 1);
            player.sendMessage(MessagesManager.getInstance().getMessage("item.consume", Map.of("time", String.valueOf(timeToAdd))));
        }
    }
}

