/*
 * Decompiled with CFR 0.152.
 */
package net.ezplace.deathTime.other;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.ezplace.deathTime.DeathTime;
import net.ezplace.deathTime.data.CacheManager;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class DeathTimePlaceholders
extends PlaceholderExpansion {
    private final DeathTime plugin;
    private final CacheManager cacheManager;

    public DeathTimePlaceholders(DeathTime plugin) {
        this.plugin = plugin;
        this.cacheManager = plugin.getCacheManager();
    }

    @NotNull
    public String getIdentifier() {
        return "deathtime";
    }

    @NotNull
    public String getAuthor() {
        return "andrewyernau";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.equalsIgnoreCase("time_left")) {
            if (player == null) {
                return null;
            }
            long timeLeft = this.cacheManager.getPlayerTime(player.getUniqueId());
            return this.formatTime(timeLeft);
        }
        return null;
    }

    private String formatTime(long seconds) {
        if (seconds <= 0L) {
            return "0";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, secs);
        }
        return String.format("%02d:%02d", minutes, secs);
    }
}

