/*
 * Decompiled with CFR 0.152.
 */
package dev.qedi.heightlimiter.events;

import com.mojang.logging.LogUtils;
import dev.qedi.heightlimiter.config.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="heightlimiter", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CommonModEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (CommonModEvents.shouldCancelSpawn(event)) {
            event.setCanceled(true);
        }
    }

    private static boolean shouldCancelSpawn(MobSpawnEvent.FinalizeSpawn event) {
        int entityY;
        Mob entity = event.getEntity();
        String modid = CommonModEvents.getEntityModId((Entity)entity);
        int topLimit = (Integer)ServerConfig.Common.HEIGHT_LIMIT_TOP.get();
        int bottomLimit = (Integer)ServerConfig.Common.HEIGHT_LIMIT_BOTTOM.get();
        boolean logging = (Boolean)ServerConfig.Common.LOGGING.get();
        String[] categories = CommonModEvents.arrayFromString((String)ServerConfig.Common.RESTRICTED_CATEGORIES.get());
        if (CommonModEvents.entityFromRestrictedMod((Entity)entity, categories) && (entityY = (int)entity.m_20186_()) >= bottomLimit && entityY <= topLimit) {
            if (logging) {
                LOGGER.info("Spawn prevented " + modid + " entity " + entity.m_7755_() + " At Y = " + entityY);
            }
            return true;
        }
        return false;
    }

    private static boolean entityFromRestrictedMod(Entity entity, String[] categories) {
        return Arrays.asList(categories).contains(CommonModEvents.getEntityModId(entity));
    }

    private static String getEntityModId(Entity entity) {
        ResourceLocation registryName = entity.m_6095_().m_204041_().m_205785_().m_135782_();
        return registryName.m_135827_();
    }

    public static String[] arrayFromString(String input) {
        Pattern pattern = Pattern.compile("'(.*?)'");
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        String[] result = list.toArray(new String[0]);
        return result;
    }
}

