/*
 * Decompiled with CFR 0.152.
 */
package dev.qedi.heightlimiter.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "heightlimiter.toml");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public static ForgeConfigSpec.ConfigValue<Integer> HEIGHT_LIMIT_TOP = null;
        public static ForgeConfigSpec.ConfigValue<Integer> HEIGHT_LIMIT_BOTTOM = null;
        public static ForgeConfigSpec.ConfigValue<String> RESTRICTED_MODS = null;
        public static ForgeConfigSpec.ConfigValue<ArrayList<String>> CUSTOM_CATEGORIES = null;
        public static ForgeConfigSpec.ConfigValue<Boolean> CUSTOM_CATEGORIES_ENABLE = null;
        public static ForgeConfigSpec.ConfigValue<Boolean> LOGGING = null;
        private static final ArrayList<String> categories = new ArrayList<String>(List.of("[mod:example1,mod:example2]%-64%64"));

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("HeightLimiter Mod Config").push("common");
            HEIGHT_LIMIT_TOP = builder.comment("\n Global limit to global restrictions").define("top_height_limit", (Object)60);
            HEIGHT_LIMIT_BOTTOM = builder.define("bottom_height_limit", (Object)-64);
            RESTRICTED_MODS = builder.comment("\n Global restriction").define("limited", (Object)"['abominations_infection']");
            CUSTOM_CATEGORIES_ENABLE = builder.comment("\n Spam in your logs? :)").define("custom categories enable", false);
            CUSTOM_CATEGORIES = builder.comment("\n Custom categories, fomrat like this [array of mobs]%bottom_limit%top_limit. \n You can add another array inside.").define("categories", categories);
            LOGGING = builder.comment("\n Spam in your logs? :)").define("write_logs", false);
            builder.pop();
        }
    }
}

