/*
 * Decompiled with CFR 0.152.
 */
package dev.qedi.heightlimiter.events;

import com.mojang.logging.LogUtils;
import dev.qedi.heightlimiter.config.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="heightlimiter", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CommonModEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        boolean logging = (Boolean)ServerConfig.Common.LOGGING.get();
        Mob entity = event.getEntity();
        int entityX = (int)entity.m_20185_();
        int entityY = (int)entity.m_20186_();
        int entityZ = (int)entity.m_20189_();
        if (CommonModEvents.shouldCancelSpawn((Entity)entity)) {
            event.setCanceled(true);
            event.setSpawnCancelled(true);
            event.isCanceled();
            event.setResult(Event.Result.DENY);
            if (logging) {
                LOGGER.info("Spawn prevented {} At XYZ {} {} {}", new Object[]{CommonModEvents.getEntityModIdAndName((Entity)entity), entityX, entityY, entityZ});
            }
        }
    }

    private static boolean shouldCancelSpawn(Entity entity) {
        int[] tmp;
        int topLimit = (Integer)ServerConfig.Common.HEIGHT_LIMIT_TOP.get();
        int bottomLimit = (Integer)ServerConfig.Common.HEIGHT_LIMIT_BOTTOM.get();
        boolean customCategoriesEnable = (Boolean)ServerConfig.Common.CUSTOM_CATEGORIES_ENABLE.get();
        String[] restrictedMods = CommonModEvents.arrayFromString((String)ServerConfig.Common.RESTRICTED_MODS.get());
        ArrayList customCategoriesList = (ArrayList)ServerConfig.Common.CUSTOM_CATEGORIES.get();
        int entityY = (int)entity.m_20186_();
        return CommonModEvents.entityFromRestrictedMod(entity, restrictedMods) ? entityY >= bottomLimit && entityY <= topLimit : customCategoriesEnable && (tmp = CommonModEvents.entityFromRestrictedCategoryList(entity, customCategoriesList))[0] == 1 && entityY >= tmp[1] && entityY <= tmp[2];
    }

    private static int[] entityFromRestrictedCategoryList(Entity entity, ArrayList<String> customCategoriesList) {
        for (String config : customCategoriesList) {
            String[] parts = config.split("%");
            if (parts.length <= 0) continue;
            String entitiesArray = parts[0];
            int bottomLimit = Integer.parseInt(parts[1]);
            int topLimit = Integer.parseInt(parts[2]);
            if (!entitiesArray.contains(CommonModEvents.getEntityModIdAndName(entity))) continue;
            return new int[]{1, bottomLimit, topLimit};
        }
        return new int[]{0, 0, 0};
    }

    private static boolean entityFromRestrictedMod(Entity entity, String[] mods) {
        return Arrays.asList(mods).contains(CommonModEvents.getEntityModId(entity));
    }

    private static String getEntityModId(Entity entity) {
        ResourceLocation registryName = entity.m_6095_().m_204041_().m_205785_().m_135782_();
        return registryName.m_135827_();
    }

    private static String getEntityModIdAndName(Entity entity) {
        ResourceLocation registryName = entity.m_6095_().m_204041_().m_205785_().m_135782_();
        return registryName.m_135827_() + ":" + registryName.m_135815_();
    }

    public static String[] arrayFromString(String input) {
        Pattern pattern = Pattern.compile("'(.*?)'");
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        String[] result = list.toArray(new String[0]);
        return result;
    }
}

